;/* $Header: /lsid/semaphore/clarinet/custom/srcusr.asm 1.11 1998/04/30 23:22:31 fredwc Exp $ */
;/* (C) Copyright 1996, 1997, Hewlett-Packard Company, all rights reserved. */
;/* */

;/* DERIVED FROM: arbbb2.asm.ux,v 1.13 96/08/22 08:55:35 donm Exp */
;/* UPDATED TO arbbb2.asm.ux,v 1.17 96/10/07 */
;/* UPDATED TO arbbb2.asm.ux,v 96/06/11 */
;/* UPDATED TO arbbb2.asm.ux,v 97/07/11 */

	page	80,66,3,3
;	page	136,66,3,3

	opt CC,CEX

	include 'hwaddr_.h'
	include 'dspset_.h'
	include 'srcset_.h'
	include 'sigout_.h'
	include 'exttbl_.h'
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; 980430 Changes:
;	* Changed output behaviour when OVERREADs occur to
;         mute and turn signal off to prevent channel swap

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; 970729 Changes:
;	* added commands for support of on-the-fly reading of
;	*   X or Y memory, see F__arbbb2_readxsetup

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; 970724 Changes:
;	* interpolation filter settling fixed and will now take longer
;	* fixes for 2 channels/dsp arb data flow
;	* misc code changes for speedup
;       * speed up on the fly commands by removing unneeded interrupt enable
;       * fixed dac overread status, referred to as source underrun in library
;       * fixed arm parameter update
;       * changed jumps to short addressing where possible to save time
;       * changed #Fxxxx to #>Fxxxx for consistant results from assembler

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;/* 970616 */
;/* Removed from standard template:  */
;/*     Synchonous dynamic command execution */
;/*     Trigger out */

;
;  To allow this code to work at 65535 sample rate, 2 channel mode, this
;  code deviates from the standard template as follows:
;	* trigger out on parameter change is removed
;	* synchronous parameter change is removed
;	* zero crossing detection removed
;	* imaginary channel removed (was inherited from zoom random)
;	* postfilter state machine table moved to internal y memory
;
;  Warning:
;	For >51200 sample rate and 2 channel mode, donot do on the fly
;	parameter (amplitude) changes.  Channel swap can occur.
;	For burst mode the parameter can be changed before arm.
;         See clari.c

;  !!! speedup suggestions:
;  !!!	    change multiple bsets and bclrs to load and stores (rampctl)

;
;;;;;;;;; externals (values taken from ver 961007)
;
; FIXED in monvects.asm with EQU:
F_monv_hostrcvint	equ $0020
F_monv_hostxmitint	equ $0022
F_monv_ssixmitint	equ $0010
;
; FIXED in bufrmps.asm via memromv.ctl:
Fbufr_x_inptr		equ $FFC2
Fbufr_y_inptr		equ $FFC3
;
; FIXED in memromv.ctl:
Fbufr_x_top		equ $FF7F
Fbufr_y_top		equ $FF7F
;
; FIXED DATA STRUCTURE  in bufrmstr.asm via memromv.ctl
Fbufparm_in		equ $0D39
Fbufparm_out		equ $0D31
;
; ROUTINES NOT FIXED now in exttbl.asm jump table:
;Fbufr_read		equ $1E2B
;Fbufr_write		equ $1DCE
;Fbufr_hpxmit_reset	equ $1DB6
;Fbdparms_gaincorr	equ $287E

; ELIMINATED:
; eliminated with a write to x:
;Fmemwritex		equ $1889
;
;;;;;;;;; end undefined externals

;
; Both x and y buffer in y memory
Fbufr_usrx_base equ $8000
Fbufr_usry_base equ $6000


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Memory use:

; Note for jset ... with out using a register many control variables
;  are in absolute short (00 thru 3f) address space so that a move
;  to a register is not needed
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  MEMORY SPACES:
;   Internal memory is fast, 0 wait state
;   External memory is slower
;	1 wait states for 40 MHz E1432 daughter board
;	2 wait states for 80 MHz 2 channel board, 2 per E1434
;
;   Program Space:
;	P:$0068-P:$0FFF	Signal mode program ($0F98, 3992wds)
;	with fast interrupts (P:$0068-P:$007F)
;		P:$0068-P:$01FF	Internal to dsp (408 words)
;		P:$0200-P:$0FFF	External to dsp (3584 words)
;
;   Variable Space:
;	X and Y data memory must be initialized by the program,
;   	no data segments are loaded
;
;	Y:$0000-Y:$00FF	Signal mode internal Y mem (256 words)
;		Y:0 Fsigoutstatus (see sigout_.h)
;		Y:1 Fsigoutcontrol (see sigout_.h)
;		Y:2 Fsigoutxeqcmdflg (see sigout_.h)
;  		L:3 to L:F (Y: and X: 3 - F) context switch registers to save
;			background routine registers
;  		L:10 to L:1F (Y: and X: 10 - 1F) long variables some must be
;			addressed in short memory space,  sequence may be
;			important for pointer indexing
;   	Y:$0100-Y:$01FF	Internal Y ROM, 256 entry sine table
;	Y:$0200-Y:$0BFF	Signal mode external Y mem (2560 words)
;	Y:$5000-Y:$FF7F	External Y RAM, available as signal buffer (44928 words)
;
;   	X:$0000-X:$00FF	Signal mode program internal X mem (256 words)
;		X:0-2 unused
;  		L:3 to L:F (Y: and X: 3 - F) context switch registers to save
;			background routine registers
;  		L:10 to L:1F (Y: and X: 10 - 1F) long variables some must be
;			addressed in short memory space,  sequence may be
;			important for pointer indexing
;   	X:$0100-X:$01FF	Internal X ROM, A law and MU law, NOT USED
;   	X:$5000-X:$FF7F	External X RAM, available as signal buffer (44928 words)
;
;   REGISTERS AND ACCUMULATORS:
;
;   DONOT USE r3, m3, n3, r4, m4, n4, r5, m5, n5, r6, m6, n6,
;       except as shown in this code.
;	r3, r4, r5 reserved for fast interrupt routines
;		r4 (outbound pointer), r5 (inbound pointer)
;	r6 is stack pointer for system code
;
;	ALL other registers, accumulators ... are used somewhere, sometime,
;	and must be saved by the interrupting routine.
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Output signal generation routines
;	Farbbb2init, in external prog memory, initializes all variables
;	F__arbbb2, the output routine, is interruptable by the host port
;	F__arbbb2e, the entry point to the output routine when there is a dac
;		 overread error.

;		Y:0-2 use by sigout variables, see sigout_.h

                   ORG    y:$0003


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; these 13 short address are used for context switch and can be long
; starts at l:03 
F_usrbkgnd_a10 	; Long a1 -> x, a0 -> y
	dc	$000000
F_usrbkgnd_b10	; Long a1 -> x, a0 -> y
	dc	$000000
F_usrbkgnd_x	; Long x1 -> x, x0 -> y
	dc	$000000
F_usrbkgnd_y	; Long y1 -> x, y0 -> y
	dc	$000000
F_usrbkgnd_a2	; a2 use y addressing
;F_usrbkgnd_b2	; b2 use x addressing
	dc	$000000
F_usrbkgnd_r0	; r0 use y addressing
;F_usrbkgnd_r1	; r1 use x addressing
	dc	$000000
F_usrbkgnd_r2	; r2 use y addressing
;F_usrbkgnd_r7	; r7 use x addressing
	dc	$000000
F_usrbkgnd_n1	; n1 use y addressing
;F_usrbkgnd_m1	; m1 use x addressing
	dc	$000000
; the following are reserved to be used if needed
	dc	$000000
	dc	$000000

; commented out to avoid addressing errors in srcbuffer_initmode and 
;	srcbuffer_mode and srcbuffer_state
;	dc	$000000
;	dc	$000000
;	dc	$000000
; ends at l:0f
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Flags and other 6 bit addressable and related variables
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

F_arbbb2chnlflgs		dc	$000000
		;	bit
		;	23   df zerocntr set
		;	22   channels done
		;	21   ch1 active
		;	20   ch2 active

F_arbbb2xeqcmdflg	dc	$000000

F_arbbb2rampgainfactor	dc	$FFFFFF	; L: nearly one $7FFFFF FFFFFF
					; L: upper 24 in x = $7FFFFF

F_arbbb2rampgaindelta	dc	$999999 ; L: long fract (48 bits)
;					  L: x: = MSW, y: = LSW
;					  x = $000019
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  rampgaindelta data format
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	F_arbbb2rampdelta is gain change at each sample based on the ramp
;	time and interrupt rate, Sample 0.
;	rampgaindelta = 1/(ramptime (sec) * sample rate (samples/sec))
;		for a sample clock of 65536 Hz and a 5 second ramp
;		the rampdelta = 1/(5*65536) = 1/327680
;			      = .000003051757813 = $000019 999999(hex)
;	31 significant bits are sufficent $XXXXXX XX0000 (hex)
;		use doubles for divide and make fraction as follows:
;	long fract = hex signed int of (dec double fraction * 2^(N-1))
;				N = # of bits in the integer
;				N = 32 for a 96000 or a series 700
;	for clock of 51200, ramp delta = 1/(5*51200) = 1/256000
;				= .00000390625 = $000020 c49ba5
;	
;

F_arbbb2rampdownstart	dc	$000000 ; L:

F_arbbb2rampctl	dc	$000000	; Y:
		;	bit	1/0
		;	23   rampingdown
		;	22   rampingup
		;	21   rampupok
		;	20   rampstart

F_arbbb2rampmode	dc	$000000	; Y:
		;	bit	1/0
		;	23   continuous
		;	22   burst
		;       if neither bit is set then rampdownonly is assumed

F_arbbb2burstcounter	dc	$000000	; L:

F_arbbb2burstdelay	dc	$000000	; L:
F_arbbb2burstend	dc	$000000	; L:
F_arbbb2holdoffend	dc	$000000	; L:
F_arbbb2burstmode	dc	$000000	; Y:
		;	bit	1/0
		;	23   burstcounterflag: on / off
		;	22   burst/not burst
		;	21   freerun
		;	20   freerun trigger request
		;	     in freerun sends trigger at the beginning of each
		;	     block if trgoutflg in Fsigoutcontrol is set
		;	 2   reset random seed at beginning of block when
		;		burst counter is on
		;	 1   output is zero/ output is signal
F_arbbb2longone		dc $FFFFFF ; L: one, X is msw 7FFFFF, Y lsw FFFFFF


; LONG Variables at l:$0020 and beyond will interfere with short x: variables
; see ORG x

;;;;; This group updates the channel 1 data block, y:$10 thru y:$17
;;	for modulo 7 access m = 6, but base must a multiple of 8
;;	in fast interrupt routine xfer use modulo 7, or 8 access with pad
;;	  or module 16 dec with pads for both channels
;;
F_arbbb2ch1cmdgainuser	dc	$7FFFFF ; Y:
F_arbbb2ch1cmdrngdac	dc	$000035 ; Y: 1 Vpk = -19.875 dB = $000035
F_arbbb2ch1cmd		dc	$000000 ; Y: dynamic signal command
;  When true, the cmd data block over writes the channel data block
;
;	bit
;	23	Command flag
;	22	Immediate command
;	20	wait for xeqcmdflg
;	19	send trigger
;;;;;


;;;;; This group updates the channel 2 data block, y:$18 thru y:$1F
;;	for modulo 7 access m = 6, but base must a multiple of 8
;;	in fast interrupt routine xfer use modulo 7, or 8 access with pad
;;	  or module 16 dec with pads for both channels
;;
F_arbbb2ch2cmdgainuser	dc	$7FFFFF ; Y:
F_arbbb2ch2cmdrngdac	dc	$000035 ; Y: 1 Vpk = -19.875 dB = $000035
F_arbbb2ch2cmd		dc	$000000 ; Y: dynamic signal command
;  When true, the cmd data block over writes the channel data block
;
;	bit
;	23	Command flag
;	22	Immediate command
;	20	wait for xeqcmdflg
;	19	send trigger
;;;;;




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;  Mode specific variables
;

;;;;;  CHANNEL 1
;;;;; This group is updated by dynamic signal commands

;;    ANY CHANGES HERE WILL REQUIRE CHANGES IN THE CMD PARAMETER COPY CODE
;;    PARAMETER RESET AND INITIALIZATION
;;
F_arbbb2ch1flgs		dc	F_arbbb2ch1flgs ; Y:
;  bit
;    23 chout (1 = on, 0 = off)
;    22 chx (0 = channel 1, 1 = channel 2)
;    21 chmode (1= 2 ch mode, 0= 1 ch mode)
;    0-15 points to next F_arbbb2chxflgs
F_arbbb2ch1cmdptr	dc	F_arbbb2ch1cmd ; Y:
F_arbbb2ch1trgout	dc	$000000 ; Y: bit 19 of cmd word written here
F_arbbb2ch1signal	dc	$000000 ; Y:
F_arbbb2ch1gaincorr	dc	$5bf43b ; Y:
;	  ch correction has a nominal value = 10/13.92, always less than 1
F_arbbb2ch1gainuser	dc	$7FFFFF ; Y:
F_arbbb2ch1rngdac	dc	$000035 ; Y: 1 Vpk = -19.875 dB = $000035
;;
;;;;;



;;;;;  CHANNEL 2
;;;;; This group is updated by dynamic signal commands

;;    ANY CHANGES HERE WILL REQUIRE CHANGES IN THE CMD PARAMETER COPY CODE

F_arbbb2ch2flgs		dc	F_arbbb2ch1flgs ; Y:
;  bit
;    23 chout (1 = on, 0 = off)
;    22 chx (0 = channel 1, 1 = channel 2)
;    21 chmode (1= 2 ch mode, 0= 1 ch mode)
;    0-15 points to next F_arbbb2chxflgs
F_arbbb2ch2cmdptr	dc	F_arbbb2ch2cmd ; Y:
F_arbbb2ch2trgout	dc	$000000 ; Y: bit 19 of cmd word written here
F_arbbb2ch2signal	dc	$000000 ; Y:
F_arbbb2ch2gaincorr	dc	$5bf43b ; Y:
;	  ch correction has a nominal value = 10/13.92, always less than 1
F_arbbb2ch2gainuser	dc	$7FFFFF ; Y:
F_arbbb2ch2rngdac	dc	$000035 ; Y: 1 Vpk = -19.875 dB = $000035
;;
;;;;;

;  Y: MEMORY ACTUALLY STARTS HERE
;
  ; ORG with notab so the load location doesnot change to p(3):
  ; when a ROM build, and no constants are saved in ROM

;
; STATIC VARIABLES IN Y SHORT (INTERNAL) MEMORY (to minimize instructions)
;	 order is important as some variables are accessed in sequence
;
F_arbbb2chxptr	dc	F_arbbb2ch1flgs
;		points to F_arbbb2ch1flgs or F_arbbb2ch2flgs.

F_arbbb2bits	dc	FSIG_DFIN_BITS  ;$008000 for DF1700(16 bits)
;	or FSIG_DFOUT_BITS, $080000 for PCM63(20 bits)

F_arbbb2trgoff	dc	FCRB_XMIT1
;	or FCRB_XMIT2
;	contains setting for ssi crb with bit 0 set

F_arbbb2trgon	dc	FCRB_XMIT1_TRG
;	or FCRB_XMIT2_TRG
;	contains setting for ssi crb with bit 0 clear
;

F_arbbb2trigoutwd	dc	$000000
F_arbbb2sigout		dc	$000000
;	
F_arbbb2stchxos	dc	0

F_arbbb2spanmode	dc	$000000 ; Y: must be below $40 for jsset (6 bit short)
;	F_arbbb2spanmode = 0 then baseband full span signal, no interpolation
;				no mixer
;  bit 23 22 21
;       1  x      5x postscale
;       0  1      4x postscale
;       0  0      2x postscale
;
;  bits 8:12 RESERVED for: mixerpassfactor (0 = no mixer, 18 = pass 17)
;
;  bit 5, if set don't settle digital filters
;
;  bits 0:4,  maxpass (0 = pass 0 ... 17 = pass17)
;	if maxpass = 0 then no postscale
;	maxpass is the getdata (no interpolate) pass
;
;  effective sample rate = sample1/(postscale * (2^(maxpass-1)) )
;
;  span mode change only effective after init, not a runtime variable


F_arbbb2_srcbuffer_state	dc	$000000 ; Y:
;		bit 8	BUFRAVAIL_A
;		bit 7	BUFRAVAIL_B
;		bit 4	data_chan: clr = chan 1, set = chan 2
;		bit 3	bufrx (A) full
;		bit 2	bufry (B) full
;		bit 1	bufrx (A) active
;		bit 0	bufry (B) active

	define	FBUFR_SISR_MASK		'$000180'
	define	FBUFRA_AVAIL_BIT	'$8'
	define	FBUFR_DATA_CHAN_BIT	'$4'
	define	FBUFRA_FULL_BIT		'$3'
	define	FBUFRA_ACTIVE_BIT	'$1'
	define	FBUFRB_AVAIL_BIT	'$7'
	define	FBUFRB_FULL_BIT		'$2'
	define	FBUFRB_ACTIVE_BIT	'$0'

F_arbbb2_srcbuffer_mode		dc	$000000 ; Y:
	define FSRCBUFFER_CONT_BIT		'$0'
	define FSRCBUFFER_PER_AB_BIT		'$1'
	define FSRCBUFFER_PER_A_BIT		'$2'
	define FSRCBUFFER_SWAUTO_BIT		'$3'
	define FSRCBUFFER_SWCMD_BIT		'$4'
	define FSRCBUFFER_MODE_DEF_BIT		'$0'
	define FSRCBUFFER_CONT			'$1'
	define FSRCBUFFER_PER_AB		'$2'
	define FSRCBUFFER_PER_A			'$4'
	define FSRCBUFFER_SWAUTO		'$8'
	define FSRCBUFFER_SWCMD			'$10'
	define FSRCBUFFER_MODE_DEF		'$4'

F_arbbb2_srcbuffer_initmode	dc	$000000 ; Y:
	define FSRCBUFFER_INIT_EMPTY		'$1'
	define FSRCBUFFER_INIT_EMPTY_BIT	'$0'
	define FSRCBUFFER_INIT_RESET_BIT	'$1'

F_arbbb2_srcbuffer_y_ptr	dc	$000000 ; Y:  next read address
F_arbbb2_srcbuffer_y_end	dc	$000000 ; Y:
;	= Fbufr_usry_base + F_arbbb2_srcbuffer_y_size
;	1 beyond last data in srcbuffer
F_arbbb2_srcbuffer_x_ptr	dc	$000000 ; Y:  next read address
F_arbbb2_srcbuffer_x_end	dc	$000000 ; Y:	
;			Fbufr_usrx_base + F_arbbb2_srcbuffer_x_size

; buffer bounds defined in memromv.ctl, use as immediate value, #
;	Fbufr_x_top		max available x:address
;	Fbufr_usrx_base		starting x:address
;	Fbufr_y_top		max available y:address
;	Fbufr_usry_base		starting y:address

; pass table counters
F_arbbb2ptbl_actr		dc	0
F_arbbb2ptbl_bctr		dc	0

F_arbbb2poststatereg	dc      0			; state register

;;;;;;;;; the following variables may be after y:$40

F_arbbb2dfdelay	dc	$000036
;	measured zero crossing df filter delay .74 ms for Fs = 65536 Hz
;	or 48.49 * 1/fs
;	reset df delay to 54 ($36) allowing for measurment error

;	Although for 2 channel mode the interrupts occur twice as fast
;	the counter is decremented on ch 1 frame only

F_arbbb2dfzeroctr	dc	$000000

F_arbbb2maxpass			dc	$000000

;;;;;;;;;;;; arb buffer variables

F_arbbb2_srcbuffer_x_size	dc	$000000 ; Y:
F_arbbb2_srcbuffer_y_size	dc	$000000 ; Y:

F_arbbb2_srcbuffer_x_max	dc	$000000 ; Y: max size
F_arbbb2_srcbuffer_y_max	dc	$000000 ; Y: max size

F_arbbb2rngmute		dc $00007F
F_arbbb2ch1rngtmp	dc	$000000 ; Y: tmp rng value
F_arbbb2ch2rngtmp	dc	$000000 ; Y: tmp rng value

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;
; filter input/output data table pass0 thru pass 16,  17 + 1 = 18
; pointed to by first entry in state table
; 
;				pass 16 in,out (= 15 in) ... pass 0 in,out
F_arbbb2datach1_r	dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
F_arbbb2datach1_i	dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
;	real out pass17 in pass 16 = F_arbbb2datach1_r
;	real out pass16, in pass 15 = F_arbbb2datach1_r + 1
;	...
;	real out pass1, in pass 0  = F_arbbb2datach1_r + 16
;	real out pass0             = F_arbbb2datach1_r + 17

F_arbbb2datach2_r	dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
F_arbbb2datach2_i	dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

F_arbbb2dataos		equ	(F_arbbb2datach1_i-F_arbbb2datach1_r)

;	postfilter pass states: 2 channel, postscale 5x
F_arbbb2poststate0_1	dc      F_arbbb2poststate0_2	; next state
			dc      F__arbbb2pass0		; ch1 action
F_arbbb2poststate0_2	dc      F_arbbb2poststate1_1	; next state
			dc      F__arbbb2pass0		; ch2 action
F_arbbb2poststate1_1	dc      F_arbbb2poststate1_2	; next state
			dc      F__arbbb2pass0		; ch1 action
F_arbbb2poststate1_2	dc      F_arbbb2poststate2_1	; next state
			dc      F__arbbb2pass0		; ch2 action
F_arbbb2poststate2_1	dc      F_arbbb2poststate2_2	; next state
			dc      F__arbbb2pass0		; ch1 action
F_arbbb2poststate2_2	dc      F_arbbb2poststate3_1	; next state
			dc      F__arbbb2pass0		; ch2 action
F_arbbb2poststate3_1	dc      F_arbbb2poststate3_2	; next state
			dc      F__arbbb2pfltrnoinc	; ch1 action
F_arbbb2poststate3_2	dc      F_arbbb2poststate4_1	; next state
			dc      F__arbbb2pfltr		; ch2 action
F_arbbb2poststate4_1	dc      F_arbbb2poststate4_2	; next state
			dc      F__arbbb2pfltrnoinc	; ch1 action
F_arbbb2poststate4_2	dc      F_arbbb2poststate0_1	; next state
			dc      F__arbbb2pfltr		; ch2 action

                ORG    y:$00FC
; Some used as l memory

F_arbbb2regsave	dc	$000000
			dc	$000000
			dc	$000000
			dc	$000000

                ORG    y:$0200
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Filter pass tables, each 256 wds long with 8 passes each.
; 16 passes maximum, not including the final stage of 2,4 or 5.

; The contents are the address of the state table for the desired pass.
; If contents of F_passtbl_a are negative (bit 23 set) link to F_passtbl_b
;   thru F_passtbl_bctr, counter.

; The following 2 tables must be on a modulo 256 boundary.

F_arbbb2ptbl_a		dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

F_arbbb2ptbl_b		dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
			dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; state tables for channel 1,2 real/imaginary, 13 words each per pass, 0-16.
;	routine, data and coef pointers plus 10 states variables

;  Channel 1:
F_arbbb2stch1_17r	dc	0 ; routine to jsr to, (filter,skip,getdata)
			dc	0 ; pointer to data
			dc	0 ; pointer to coeficients
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_17i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_16r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_16i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_15r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_15i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_14r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_14i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_13r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_13i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_12r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_12i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_11r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_11i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_10r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_10i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_9r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_9i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_8r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_8i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_7r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_7i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_6r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_6i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_5r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_5i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_4r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_4i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_3r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_3i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_2r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_2i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_1r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_1i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_0r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch1_0i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables

;  Channel 2:
F_arbbb2stch2_17r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_17i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_16r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_16i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_15r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_15i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_14r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_14i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_13r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_13i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_12r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_12i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_11r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_11i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_10r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_10i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_9r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_9i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_8r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_8i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_7r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_7i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_6r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_6i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_5r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_5i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_4r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_4i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_3r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_3i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_2r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_2i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_1r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_1i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_0r	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables
F_arbbb2stch2_0i	dc	0,0,0 ; routine, data, coef ptrs
			dc	0,0,0,0,0,0,0,0,0,0  ; 10 state variables

F_arbbb2stch2os	equ	$800000+(F_arbbb2stch2_0r-F_arbbb2stch1_0r)
;	   	bit 23 if set ch2, else ch1

F_arbbb2burstmodetmp	dc	$000000	; Y:
F_arbbb2rampmodetmp	dc	$000000	; Y:
F_arbbb2_precalc_a	dc	$000000	; Y:
F_arbbb2_precalc_b	dc	$000000	; Y:

                ORG    x:$0003
;	These variables are in short x space ( < $40)
;	Check to be sure that this does not conflict with L var locations

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; these 13 short address are used for context switch and can be long
; starts at l:03 
;F_usrbkgnd_a10 	; Long a1 -> x, a0 -> y
	dc	$000000
;F_usrbkgnd_b10	; Long a1 -> x, a0 -> y
	dc	$000000
;F_usrbkgnd_x	; Long x1 -> x, x0 -> y
	dc	$000000
;F_usrbkgnd_y	; Long y1 -> x, y0 -> y
	dc	$000000
;F_usrbkgnd_a2	; a2 use y addressing
F_usrbkgnd_b2	; b2 use x addressing
	dc	$000000
;F_usrbkgnd_r0	; r0 use y addressing
F_usrbkgnd_r1	; r1 use x addressing
	dc	$000000
;F_usrbkgnd_r2	; r2 use y addressing
F_usrbkgnd_r7	; r7 use x addressing
	dc	$000000
;F_usrbkgnd_n1	; n1 use y addressing
F_usrbkgnd_m1	; m1 use x addressing
	dc	$000000
; the following are reserved to be used if needed
	dc	$000000
	dc	$000000
	dc	$000000
	dc	$000000
	dc	$000000
; ends at l:0f
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

                ORG    x(0):$0020,x(1):$0020
;	These variables are in short x space
;	Check to be sure that this does not conflict with L var locations

F_arbbb2_txout		dc	0

F_arbbb2_bufrsw_flag	dc	0
;		bit 1	switch to bufry (B)
;		bit 0	switch to bufrx (A)
	define	FBUFRSW2B_BIT		'$1'
	define	FBUFRSW2A_BIT		'$0'
	

                ORG    x:$0080

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;  x:80..9f	filter coefficients for postscaler, 4x, modulo 32
;  x:a0..bf	filter coefficients for postscaler, 5x, modulo 32
;  x:c0..df	filter coefficients for pass 1..N 2x, modulo 32
;  x:e0..ff     reserved for register save if needed

;---------------------------------------;
; DIGITAL FILTER TOPOLOGY:
;                               WN
;  XN -- A1 --> (-) ------------+----- A2 ----> (+) ----> YN  
;                ^              |                ^
;                |             1/z               |
;                |              | WNm1           |
;                +<---- B ------+----- A2D ----->+
;                |              |                |
;                |             1/z               |
;                |              | WNm2           |
;                +<---- C ------+----- A2E ----->+
;         
;     All coefficents are scaled by 1/2.
;     XN = input[i];
;     WNm2 = WNm1;
;     WNm1 = WN;
;     T1 = (A1 * XN) - (B * WNm1);
;     T2 = T1 - (C * WNm2);
;     WN = 2.0 * T2;
;     T4 = (A2E * WNm2) + (A2D * WNm1);
;     T5 = T4 + (A2 * WN);
;     YN = 2.0 * T5;
;     YN = 2*A2*( (2*A1*XN)-(2*B*WNm1)-(2*C*WNm2) ) + 2*A2E*WNm2 + 2*A2D*WNm1

;
;
;  
;

;---------------------------------------;  over written on reset from p:
;  10th Order Elliptic Lowpass Filter	;
;	4x, postscaler			;
;  passband edge : 0.09765625 of Fs	;
;  stopband edge : 0.146484375 of Fs	;
;  ripple        : +0/-0.01 dB          ;
;  stopband atten: -110.0427 dB		;
;  step response delay: 14 samples	;
;  peak overshoot (step input): 1.211	;
;  coefficents				;
;---------------------------------------;
					; ------Section 1-
F_arbbb2post4	dc	0.0354916    	; A1
         	dc	0.4757653    	; C  
     		dc     -0.7831376    	; B    
     		dc	0.4999999    	; A2E    
     		dc     -0.5994734    	; A2D    
     		dc	0.4999999    	; A2    
					; ------Section 2-
		dc	0.4266566    	; C  
    		dc	0.0894603    	; A1
     		dc     -0.7629465    	; B    
     		dc	0.4999999    	; A2E    
     		dc     -0.5449690    	; A2D    
     		dc	0.4999999    	; A2    
					; ------Section 3-
		dc	0.3737872    	; C  
    		dc	0.1101888    	; A1
     		dc     -0.7548145    	; B    
     		dc	0.4999999    	; A2E    
     		dc     -0.3940303    	; A2D    
     		dc	0.4999999    	; A2    
					; ------Section 4-             
         	dc	0.3226390    	; C  
    		dc	0.0875319    	; A1
     		dc     -0.7533445    	; B    
     		dc	0.4999999    	; A2E    
     		dc     -0.0114714    	; A2D    
     		dc	0.4999999    	; A2    
					; ------Section 5-
		dc	0.2891445    	; C  
    		dc	0.0479547*4    	; A1'
;			since only 1 of 4 inputs are none zero,  A1' = A1 * 4
     		dc     -0.7541006    	; B    
     		dc	0.4999999    	; A2E    
     		dc      0.7737799   	; A2D    
     		dc	0.4999999    	; A2    
					; ----------------


                ORG    x:$00A0
;---------------------------------------;  over written on reset from p:
;  10th Order Elliptic Lowpass Filter	;
;	5x, postscaler			;
;  passband edge : 0.078125 of Fs	;
;  stopband edge : 0.1171875 of Fs	;
;  ripple        : +0/-0.01 dB          ;
;  stopband atten: -108.2181 dB		;
;  step response delay: 17 samples	;
;  peak overshoot (step input): 1.214	;
;  coefficents				;
;---------------------------------------;
					; ------Section 1-
F_arbbb2post5	dc	0.0354735   	; A1
         	dc	0.4802872    	; C  
     		dc     -0.8547770    	; B    
     		dc	0.4999999    	; A2E    
     		dc     -0.7366979    	; A2D    
     		dc	0.4999999    	; A2    
					; ------Section 2-
		dc	0.4398175    	; C  
    		dc	0.0899066    	; A1
     		dc     -0.8323625    	; B    
     		dc	0.4999999    	; A2E    
     		dc     -0.6977729    	; A2D    
     		dc	0.4999999    	; A2    
					; ------Section 3-
		dc	0.3955683    	; C  
    		dc	0.1069911    	; A1
     		dc     -0.8169905    	; B    
     		dc	0.4999999    	; A2E    
     		dc     -0.5848429    	; A2D    
     		dc	0.4999999    	; A2    
					; ------Section 4-             
         	dc	0.3522180    	; C  
    		dc	0.0775019    	; A1
     		dc     -0.8062215    	; B    
     		dc	0.4999999    	; A2E    
     		dc     -0.2601891    	; A2D    
     		dc	0.4999999    	; A2    
					; ------Section 5-
		dc	0.3235888    	; C  
    		dc	0.0333010*5    	; A1'
;			since only 1 of 5 inputs are none zero,  A1' = A1 * 5
     		dc     -0.8002595    	; B    
     		dc	0.4999999    	; A2E    
     		dc      0.6491189   	; A2D    
     		dc	0.4999999    	; A2    
					; ----------------

                ORG    x:$00C0
;---------------------------------------;  over written on reset from p:
;  8th Order Elliptic Lowpass Filter	;
;  in 10th Order Filter function	;
;	2x, multipass			;
;  passband edge : 0.1953125 of Fs	;
;  stopband edge : 0.29296875 of Fs	;
;  ripple        : +0/-0.01102584 dB    ;
;  stopband atten: -96 dB		;
;  step response delay: 5 samples	;
;  peak overshoot (step input): 1.204	;
;  coefficents				;
;---------------------------------------;
					; ------Section 1-
F_arbbb2mpass	dc	0.0541295    	; A1
         	dc	0.4372871    	; C  
     		dc     -0.2537656    	; B    
     		dc	0.4999999    	; A2E    
     		dc      0.2818571    	; A2D    
     		dc	0.4999999    	; A2    
					; ------Section 2-
		dc	0.3181438    	; C  
    		dc	0.1358378    	; A1
     		dc     -0.2940181    	; B    
     		dc	0.4999999    	; A2E    
     		dc      0.4078847    	; A2D    
     		dc	0.4999999    	; A2    
					; ------Section 3-
		dc	0.2007574    	; C  
    		dc	0.1794851    	; A1
     		dc     -0.3761743    	; B    
     		dc	0.4999999    	; A2E    
     		dc      0.6665955    	; A2D    
     		dc	0.4999999    	; A2    
					; ------Section 4-             
         	dc	0.1170592    	; C  
    		dc	0.1595616    	; A1
     		dc     -0.4469378    	; B    
     		dc	0.4999999    	; A2E    
     		dc      0.9496368    	; A2D    
     		dc	0.4999999    	; A2    
					; ------Section 5-
;	since only 1 of 2 inputs are none zero, output =4*A1*A2= 2
		dc	0.0           	; C
    		dc	0.4999999      	; A1
     		dc      0.0          	; B    
     		dc	0.0          	; A2E    
     		dc      0.0         	; A2D    
     		dc	0.9999999    	; A2    
					; ----------------
                ORG    x:$00E0
F_arbbb2txnull dc	0	; bitbucket for output durring init filter
				; settling

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	
;  NOTES:
;	1. Host port interrupt routines for dynamic signal commands
;	   should be quick, assembler.
;	2. No digital offset correct is done as this would create a
;	   glitch when an output begins with the trigger, since
;	   when not outputing, the df1700 or PCM63 will see all ones,
;	   a value near zero, on the serial data input.
;



	org	p:$68

;;; the following interrupts vectors starting at p:$68 are defined
;;; by the source mode
			; sigout src mode imed cmd 12
ARBBB2CMD_B4	jsr >F__arbbb2_dyncmdend ; end dyn cmd mode

ARBBB2CMD_B5	jsr >F__arbbb2_dyncmdch1 ; setup dyn cmd for ch 1

ARBBB2CMD_B6	jsr >F__arbbb2_dyncmdch2 ; setup dyn cmd for ch 2

ARBBB2CMD_B7	jsr >F__arbbb2_readxsetup ; setup data read x space

ARBBB2CMD_B8	jsr >F__arbbb2_readysetup ; setup data read y space

ARBBB2CMD_B9	jsr >F__arbbb2_x2b ; switch to buffer b (bufry) immediately

ARBBB2CMD_BA	jsr >F__arbbb2_x2a ; switch to buffer a (bufrx) immediately

ARBBB2CMD_BB	jsr >F__arbbb2_xferb_done ; sets bufry full

ARBBB2CMD_BC	jsr >F__arbbb2_xferb_setup ; sets up recdata irq for b (bufry)

ARBBB2CMD_BD	jsr >F__arbbb2_xfera_done ; sets bufrx full

ARBBB2CMD_BE	jsr >F__arbbb2_xfera_setup ; sets up recdata irq for a (bufrx)

ARBBB2CMD_BF	jsr >F__arbbb2_sisrupdate ; updates buffer available bits

;;;;;;  standard entry points 
Farbbb2_reset	jmp >F__arbbb2reset  ; loads interrupt vectors, constants, etc
Farbbb2_init	jmp >F__arbbb2init   ; initializes with setup parameters
Farbbb2_cmd	jmp >Farbbb2cmd	; executes command from buffer
Farbbb2_bkgnd	rts
;Farbbb2_bkgnd	jmp >F__arbbb2bkgnd ; executes background routine if any

;
;       610 (1ch) or 305 (2ch) clock cycles available per interrupt
;	     with 65536 Fs


F__arbbb2_filter

; derived from Vibrato code 950209
; x2, x4, and x5 filtering all done with this 5 section filter using
; different coeficients.

; for speed reasons this is a subroutine so that other functionality has
; room in internal p memory for fast execution

; Coefficients in internal x memory, states are in external y memory

; internal y memory used by other routines

	move y:(r0)+,r2			; r2 -> input, r2+ -> output
	clr a y:(r0)+,r7			; r7 -> coeff
					; r0 -> states
	ori #$08,mr			; set X2 accumulator scaling mode
	move y:(r2),y0	x:(r7)+,x1	; get data and first coefficient
	move a0,y:(r2)+		; clear input data to insert zeros

;------- SECTION 1 -----------------------------;
	mpy	y0,x1,a	 y:(r0)+,y0  x:(r7)+,x0		
						; accA = A1 * XN
						; get WNm2
						; get C coefficent
	mac	-y0,x0,a  y:(r0)-,y1  x:(r7)+,x0
						; accA = A1*XN - C*WNm2
						; get WNm1
						; get B coefficent
	macr	-y1,x0,a  y1,y:(r0)+  x:(r7)+,x0
						; WN = accA=A1*XN-C*WNm2-B*WNm1
						; WNm2 = WNm1
						; get A2E coefficent
	mpy	y0,x0,a  a,y:(r0)  x:(r7)+,x0
						; WNm1 = WN
						; accA = A2E * WNm2
						; get A2D coefficent
	mac	y1,x0,a	 y:(r0)+,y0  x:(r7)+,x0
						; accA = A2E*WNm2 + A2D*WNm1
						; get WN
						; get A2 coefficent
	macr	y0,x0,a	 y:(r0)+,y0  x:(r7)+,x0
						; accA = A2E*WNm2+A2D*WNm1+A2*WN
						; get WNm2 for next iteration
						; get C coefficent for next iter
;------- SECTION 2 -----------------------------;
	mpy	-y0,x0,a  a,y1  x:(r7)+,x0
						; accA = - C*WNm2
						; save VN
						; get A1 coefficent

	mac	y1,x0,a   y:(r0)-,y1  x:(r7)+,x0
						; accA = A1 * XN - C*WNm2
						; get B coefficent
						; get WNm1

	macr	-y1,x0,a  y1,y:(r0)+  x:(r7)+,x0
						; WN = accA=A1*XN-C*WNm2-B*WNm1
						; WNm2 = WNm1
						; get A2E coefficent
	mpy	y0,x0,a  a,y:(r0)  x:(r7)+,x0
						; WNm1 = WN
						; accA = A2E * WNm2
						; get A2D coefficent
	mac	y1,x0,a	 y:(r0)+,y0  x:(r7)+,x0
						; accA = A2E*WNm2 + A2D*WNm1
						; get WN
						; get A2 coefficent
	macr 	y0,x0,a	 y:(r0)+,y0  x:(r7)+,x0
						; accA = A2E*WNm2+A2D*WNm1+A2*WN
						; get WNm2 for next iteration
						; get C coefficent for next iter
;------- SECTION 3 -----------------------------;
	mpy	-y0,x0,a  a,y1  x:(r7)+,x0
						; accA = - C*WNm2
						; save XN
						; get A1 coefficent

	mac	y1,x0,a   y:(r0)-,y1  x:(r7)+,x0
						; accA = A1 * XN - C*WNm2
						; get B coefficent
						; get WNm1

	macr	-y1,x0,a  y1,y:(r0)+  x:(r7)+,x0
						; WN = accA=A1*XN-C*WNm2-B*WNm1
						; WNm2 = WNm1
						; get A2E coefficent
	mpy	y0,x0,a  a,y:(r0)  x:(r7)+,x0
						; WNm1 = WN
						; accA = A2E * WNm2
						; get A2D coefficent
	mac	y1,x0,a	 y:(r0)+,y0  x:(r7)+,x0
						; accA = A2E*WNm2 + A2D*WNm1
						; get WN
						; get A2 coefficent
	macr 	y0,x0,a	 y:(r0)+,y0  x:(r7)+,x0
						; accA = A2E*WNm2+A2D*WNm1+A2*WN
						; get WNm2 for next iteration
						; get C coefficent for next iter
;------- SECTION 4 -----------------------------;
	mpy	-y0,x0,a  a,y1  x:(r7)+,x0
						; accA = - C*WNm2
						; save XN
						; get A1 coefficent

	mac	y1,x0,a   y:(r0)-,y1  x:(r7)+,x0
						; accA = A1 * XN - C*WNm2
						; get B coefficent
						; get WNm1

	macr	-y1,x0,a  y1,y:(r0)+  x:(r7)+,x0
						; WN = accA=A1*XN-C*WNm2-B*WNm1
						; WNm2 = WNm1
						; get A2E coefficent
	mpy	y0,x0,a  a,y:(r0)  x:(r7)+,x0
						; WNm1 = WN
						; accA = A2E * WNm2
						; get A2D coefficent
	mac	y1,x0,a	 y:(r0)+,y0  x:(r7)+,x0
						; accA = A2E*WNm2 + A2D*WNm1
						; get WN
						; get A2 coefficent
	macr 	y0,x0,a	 y:(r0)+,y0  x:(r7)+,x0
						; accA = A2E*WNm2+A2D*WNm1+A2*WN
						; get WNm2 for next iteration
						; get C coefficent for next iter
;------- SECTION 5 -----------------------------;
	mpy	-y0,x0,a  a,y1  x:(r7)+,x0
						; accA = - C*WNm2
						; save XN
						; get A1 coefficent

	mac	y1,x0,a   y:(r0)-,y1  x:(r7)+,x0
						; accA = A1 * XN - C*WNm2
						; get WNm1
						; get B coefficent

	macr	-y1,x0,a  y1,y:(r0)+  x:(r7)+,x0
						; WN = accA=A1*XN-C*WNm2-B*WNm1
						; WNm2 = WNm1
						; get A2E coefficent
	mpy	y0,x0,a  a,y:(r0)  x:(r7)+,x0
						; WNm1 = WN
						; accA = A2E * WNm2
						; get A2D coefficent
	mac	y1,x0,a	 y:(r0)+,y0  x:(r7)+,x0
						; accA = A2E*WNm2 + A2D*WNm1
						; get WN
						; get A2 coefficent
						; r0 points to imaginary
	macr	y0,x0,a
					; accA = A2E*WNm2+A2D*WNm1+A2*WN
						; accA has output
	move a,y:(r2)				; store output
;			must do "move a,y:(r2)" here for proper scaling
;			value in a is 1/2 of actual output y:(r2)
	andi #$F3,mr				; reset scaling mode

	rts ; F__arbbb2_filter, r2 points to output

F__arbbb2
;		movep #>$2,x:<<Fdsp_pcd ;DEBUG set test bit for timing meas

; Interrupt Procedure Description, in internal prog memory:
;

;	!!! add save of a few reg used by "calling" routine if needed
; r0, r1, r2
; a
; x0, y0
; n1

		move a10,l:<F_usrbkgnd_a10
		move a2,y:<F_usrbkgnd_a2
		move x,l:<F_usrbkgnd_x
		move y,l:<F_usrbkgnd_y
		move r0,y:<F_usrbkgnd_r0
		move r1,x:<F_usrbkgnd_r1
		move r2,y:<F_usrbkgnd_r2
		move n1,y:<F_usrbkgnd_n1
		move m1,x:<F_usrbkgnd_m1

;		move b10,l:<F_usrbkgnd_b10
;		move b2,x:<F_usrbkgnd_b2
;		move r7,x:<F_usrbkgnd_r7

		bset #21,y:<Fsigoutstatus ; set bit indicating running
					; not waiting for framesync

		clr a y:<F_arbbb2chxptr,r1	; r1 = &F_arbbb2chxflgs
			; initialize filterstate offset and chnl flg (ch1)
		move a0,y:<F_arbbb2stchxos
; IF CHANNEL 1
;		JSETBUG with r1, y1
;		jset #22,y:(r1)+,F__arbbb2_cnttst	; ch1? no, skip stuff
;		jset or jclr with indirect, y:(r1), doesnot work, 6 places
		move y:(r1)+,b0	; after increment r1 -> chxcmdptr
		jset #22,b0,F__arbbb2_ch2cnt	; ch1? no, skip stuff
; THEN

; IF SIGOFF, NO RAMPDOWN
		jclr #23,y:<Fsigoutcontrol,F__arbbb2_done0 ; sigoff? no cont.
		bset #22,y:<F_arbbb2chnlflgs	; set channels done


; IF CHANNELS DONE, OUTPUT 0 THROUGHOUT SSI AND DF

F__arbbb2_done0	jclr #22,y:<F_arbbb2chnlflgs,F__arbbb2test2
						;chnls done?,no,cont.
F__arbbb2_done1	jset #23,y:<F_arbbb2chnlflgs,F__arbbb2_done3 ; yes,df counterset?
			 ; yes then rtn, letting arbbb2e send zeros
		move y:F_arbbb2dfdelay,y1	      ; no, set up df counter
		move y1,y:F_arbbb2dfzeroctr
		bset #23,y:<F_arbbb2chnlflgs	      ; set counterset flag
F__arbbb2_done2
;		move y:<F_arbbb2trgoff,y1		; trig off
;		move y1,y:<F_arbbb2trigoutwd
	jclr #23,y:<Fsigoutcontrol,F__arbbb2_zerosigout ; not off so dont mute
		jmp <F__arbbb2_sigoutmute	; output a zero with mute

F__arbbb2_done3	clr b
		move y:F_arbbb2dfzeroctr,b0
		dec b				;  yes decrement until done
		jmi <F__arbbb2_done4
		move b0,y:F_arbbb2dfzeroctr
		jmp <F__arbbb2_done2

F__arbbb2_done4	bset #23,y:<Fsigoutstatus	; set bit indicating sig done
		jmp <F__arbbb2_done2

F__arbbb2_ch2cnt move	#>F_arbbb2stch2os,b0
		move b0,y:<F_arbbb2stchxos
			; set filterstate offset and chnl flg (ch2)
		jset #23,y:<F_arbbb2chnlflgs,F__arbbb2_done4
			; if df cntr set send 0
		jmp <F__arbbb2_icmd1


; IF RAMP2SIGOFF

F__arbbb2test2
;#	jclr #22,y:<Fsigoutcontrol,F__arbbb2_xqflg1
;# 						; rmp2sigoff? no cont.
;# 		jset #23,y:<F_arbbb2rampctl,F__arbbb2_xqflg1
;# 				; if rampingdown then skip
;# 		bset #23,y:<F_arbbb2rampctl	; set ramping down
;# 		bclr #22,y:<F_arbbb2rampctl	; clear rampingup
;# 		bclr #21,y:<F_arbbb2rampctl	; clr rampupok

;# 		; set the ramping bit on the status word
;# 		movep #>FSISR_RAMPON,y:<<Fsrc_sisr

; SAMPLE xeqcmdflgin AND CLEAR IT
;# F__arbbb2_xqflg1	move y:<Fsigoutxeqcmdflg,y1
;# 		move y1,y:<F_arbbb2xeqcmdflg
;# 		move a1,y:<Fsigoutxeqcmdflg

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;   RAMPING
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;	burst rampmode description:
;
;	Ramp up time = ramp down time
;	The first and last point in the block are zero.
;	The first point begins at burstcounter = burstdelay.
;		Sine wave and LO phases start here even though the output
;		is scaled to 0.
;	The last point is at burst counter = burstend.
;	Ramping down begins at burst counter = (burstend - ramptime).
;       The ramp free time of the burst is shortened by 2*ramptime,
;		for constant burstdelay and burst end.
;
;      RAMPGAINFACTOR
;
;    1               ___________
;                   /            \
;                  /              \
;                 /                \
;                /                  \
;     0  -------                      ----------
;        +------+----+----------+----+----------+
;        t0     t1   t2         t3   t4         t5
;
;        rampmode = burst
;
;        t0 = system measurement trigger (burstcounter = 0)
;        t1 = burst delay (first nonzero point if not in burst rampmode)
;		at burst delay the rampgainfactor is 0
;        t2 = input data aquisition begins (input trigger delay time
;		from system trigger)
;        t3 = rampdownstart = burstend - ramptime
;		at rampdownstart the rampgainfactor is 1
;        t4 = burst end (last nonzero point if not in burst rampmode)
;        t5 = burst holdoff end, the last time period required for this
;		burst, then source can request another system trigger.
;
;        t1 - t0 = burst delay
;        (t4 - t1)+1 = burst signal length
;        (t3 - t2)+1 = ramp free measurement length
;        t5 - t4 = burst hold off
;        (t5 - t0)+1 = burst period
;
;  Example setup:
;	y:Fsigoutcontrol	= $200000  source trigger on
;	l:F_arbbb2burstdelay	= $000000000040
;	l:F_arbbb2burstend	= $000000000700
;	l:F_arbbb2burstholdoffend = $000000000800
;	y:F_arbbb2burstmode	= $E00000
;					bit23 burst counter on
;					bit22 burst
;					bit21 freerun
;	y:F_arbbb2rampmode	= $400000
;					bit22 burst
;	y:F_arbbb2rampctl	= $200000
;					bit21 rampupok
;	l:F_arbbb2rampgaindelta	= $002aaaa9f3ba
;				= hex(1/$300), ramplength = $300
;				$300 = 768 dec FS periods
;				1/768 = 0.00132083
;	l:F_arbbb2rampgainfactor	= $000000000000
;	l:F_arbbb2downstart	= $000000000400
;				rampdown goes from $401 to $700


;#		jclr #23,y:<F_arbbb2rampctl,F__arbbb2ramp2 ; not ramp up
; IF RAMPING DOWN
;#		move l:<F_arbbb2rampgaindelta,a
;#		move l:<F_arbbb2rampgainfactor,b
;#		sub a,b 
;#	; rampfactor = rampfactor -rampdelta
;#		jgt <F__arbbb2ramp3 ; rampdown not done, continue
;#
;#	; if rampfactor <= 0, rampdown is done
;#		clr b	;   then rampfactor = 0
;#
;#		bclr #23,y:<F_arbbb2rampctl	; clr ramping down
;#
;#		movep #>FSISR_RAMPOFF,y:<<Fsrc_sisr ; set rampoff status bit
;#
;#	jclr #22,y:<Fsigoutcontrol,F__arbbb2ramp1 ; ramp2sigoff? no
;#
;#	;	sigoutctl = ramp2sigoff
;#	bset #22,y:<F_arbbb2chnlflgs	; set chnlsdone and skip rest
;#	jmp <F__arbbb2ramp3
;#
;#
;# F__arbbb2ramp1
;#		jclr #22,y:<F_arbbb2rampmode,F__arbbb2ramp1_1
;#			; if rampmode # burst
;#
;#	;	else rampmode = burst then
;#		bset #21,y:<F_arbbb2rampctl	; set rampupok
;#		jmp <F__arbbb2ramp3
;#
;# F__arbbb2ramp1_1		bset #22,y:<F_arbbb2chnlflgs	; set chnlsdone
;#		jmp 	<F__arbbb2ramp3
;#
;# F__arbbb2ramp4	
;#		jclr #23,y:<F_arbbb2rampmode,F__arbbb2ramp5
;#	;  if rampmode = continuous, then:
;#		jclr #20,y:<F_arbbb2rampctl,F__arbbb2ramp5
;#	; if rampupstart is set, then:
;#		bset #22,y:<F_arbbb2rampctl	; set rampingup
;#		bclr #21,y:<F_arbbb2rampctl	; clr rampupok
;#		bclr #20,y:<F_arbbb2rampctl	; clr rampupstart
;#		; set the ramping bit on the status word
;#		movep #>FSISR_RAMPON,y:<<Fsrc_sisr
;#		jmp <F__arbbb2ramp5
;#
;# F__arbbb2ramp2	jclr #22,y:<F_arbbb2rampctl,F__arbbb2ramp4 ; not ramp down
;#; IF RAMPING UP
;#		move l:<F_arbbb2rampgaindelta,a
;#		move l:<F_arbbb2rampgainfactor,b
;#		add a,b
;#	; rampfactor = rampfactor +rampdelta
;#
;#		move l:F_arbbb2longone,a  ; a = 1
;#		cmp a,b 
;#		jlt <F__arbbb2ramp3 ; ramp up not done b < 1
;#
;#	; if rampfactor >= 1, rampup is done
;#		tfr a,b ;  then rampfactor = 1
;#
;#		bclr #22,y:<F_arbbb2rampctl	; clr rampingup
;#
;#		movep #>FSISR_RAMPOFF,y:<<Fsrc_sisr
;#	;	set rampdone status bit
;#
;# F__arbbb2ramp3 move b,l:<F_arbbb2rampgainfactor

F__arbbb2ramp5	 ; ramp test done


; BURST COUNTER
; IF CHANNEL BURST DELAY, OR HOLDOFF THEN SET burstzeroflg bit 1 of burstmode
;   to output zero

; Trigger delay time could be added, but this would result in timing
; differences for source triggered versus other triggers, since the other
; triggers could not be anticipated.  The trigger timing reference needs
; to be the VXI trigger line.

F__arbbb2_burst	jclr #23,y:<F_arbbb2burstmode,F__arbbb2burst6
		; if burst counter is off skip burst stuff

		clr b l:<F_arbbb2burstcounter,a   ; move burst counter into a
		cmp b,a

		jne <F__arbbb2burst1
		; if eq then beginnning of the burst
		; send trigger by setting trigger request
;		bset #20,y:<F_arbbb2burstmode

		; reset initial sine phase
; !!! no way to adjust initial phase on the fly via dynamic signal command
; !!! however it could be changed from a command dedicated short interrupt
; !!! routine
;		move l:<F_arbbb2ch1phaseinit,b
;		move b,l:<F_arbbb2ch1phaseaccum
;		move l:<F_arbbb2ch2phaseinit,b
;		move b,l:<F_arbbb2ch2phaseaccum

		jclr #21,y:<F_arbbb2rampctl,F__arbbb2burst1
				; if rampupok is clear then skip
		bset #20,y:<F_arbbb2rampctl	; set rampupstart
		
F__arbbb2burst1
	;	move l:<F_arbbb2burstdelay,b  ; move burst delay into b

		; the counter is initialized to 0, the first pt is at 0
		; if F_arbbb2burstdelay = 0 then no burst delay
		; the signal starts when counter = burstdelay
		; the signal ends when counter = burstend

		; for burstdelay of 3 and burstend of 12 the signal
		; is off for 0,1,2 and on for 3 thru 12 (10 samples)

		; cmp b,a		;counter - delay
		; jlt <F__arbbb2burst3  ; delay > counter, output zero
				; if delay <= counter

		jclr #20,y:<F_arbbb2rampctl,F__arbbb2burst1_1
				; if rampupstart is clear then skip
		bset #22,y:<F_arbbb2rampctl	; set rampingup
		bclr #21,y:<F_arbbb2rampctl	; clr rampupok
		bclr #20,y:<F_arbbb2rampctl	; clr rampupstart


		; set the ramping bit on the status word
		movep #>FSISR_RAMPON,y:<<Fsrc_sisr

		jset #22,y:<F_arbbb2rampmode,F__arbbb2burst1_1
		;	if rampmode is burst then continue
		jset #22,y:<F_arbbb2burstmode,F__arbbb2burst1_1
			 ; burstmode = burst, continue
		bclr #23,y:<F_arbbb2burstmode ; not burstmode, turn off burstctr
		jmp <F__arbbb2burst6 ; no more burstcntr checking

F__arbbb2burst1_1 move l:<F_arbbb2rampdownstart,b  ; move rampdownstart into b
			; rampdownstart is set to burstend - ramptime

		tst b
		jeq <F__arbbb2burst2  ; rampdownstart =0 dont start rampdown

		cmp b,a		   ; counter - rampdownstart
		jne <F__arbbb2burst2  ; rampdownstart # counter, cont
		jset #23,y:<F_arbbb2rampctl,F__arbbb2_burst1_2
				; if rampingdown then skip
		bset #23,y:<F_arbbb2rampctl	; set ramping down
		bclr #22,y:<F_arbbb2rampctl	; clear rampingup
		bclr #21,y:<F_arbbb2rampctl	; clr rampupok

		; set the ramping bit on the status word
		movep #>FSISR_RAMPON,y:<<Fsrc_sisr

F__arbbb2_burst1_2 jset #22,y:<F_arbbb2burstmode,F__arbbb2burst2
			 ; burstmode = burst, continue
		bclr #23,y:<F_arbbb2burstmode ; not burstmode, turn off burstctr
		jmp <F__arbbb2burst6 ; no more burstcntr checking

F__arbbb2burst2	move l:<F_arbbb2burstend,b	; move burstend into b
		cmp b,a		   ; counter - burstend
		jlt <F__arbbb2burst4  ; burstend > counter, output signal

		jgt <F__arbbb2burst2_1 ; burstend < counter, check holdoffend

		; burstend = counter, check holdoffend, don't set zero output

		bclr #1,y:<F_arbbb2burstmode	; clr burstzeroflag

		move l:<F_arbbb2holdoffend,b	   ; move holdoffend into b
		cmp b,a		; counter - holdoffend
				   ; holdoff should not include df delay
		jge <F__arbbb2burstdone ; holdoff <= counter, burstdone


F__arbbb2burst2_1 move l:<F_arbbb2holdoffend,b   ; move holdoffend into b
		cmp b,a		; counter - holdoffend
				   ; holdoff should not include df delay
		jlt <F__arbbb2burst3 ; holdoff > counter, output zero

		bset #1,y:<F_arbbb2burstmode      ; set burstzeroflag

F__arbbb2burstdone jset #21,y:<F_arbbb2burstmode,F__arbbb2burst2_2
			; if freerun don't turn off counter
		bclr #23,y:<F_arbbb2burstmode ; burst done, turn off burstctr
		bset #22,y:<F_arbbb2chnlflgs     ; set chnlsdone

F__arbbb2burst2_2 clr a				; reset counter
		move a,l:<F_arbbb2burstcounter
		jmp <F__arbbb2burst6

F__arbbb2burst3  bset #1,y:<F_arbbb2burstmode      ; set burstzeroflag
		jmp <F__arbbb2burst5
F__arbbb2burst4	bclr #1,y:<F_arbbb2burstmode	; clr burstzeroflag
F__arbbb2burst5	inc a ; increment counter
		move a,l:<F_arbbb2burstcounter
F__arbbb2burst6

;	end of channel 1 stuff

; IF IMMEDIATE COMMAND FOR THIS CHANNEL THEN DO COMMAND
F__arbbb2_icmd1
		clr a y:(r1)+,r7  ; r7 = &F_arbbb2chxcmd 
				 ; after increment r1 -> &arbbb2chxtrigout

;		JSETBUG with r1, y1
;		jclr #22,y:(r7),F__arbbb2_xcmd1 ; bit 22 set is an immediate cmd
;# 		move y:(r7),b0
;# 		jclr #22,b0,F__arbbb2_xcmd1 ; bit 22 set is an immediate cmd

;	Copy command parameter block
;# F__arbbb2_icmd2	
;# 		move #2,n2	; 2 parameter words excluding command
;# 		move #3,n0	; will skip:  signal, gaincorr
;# 		move r7,r2
;# 		move r1,r0	; r0 = &F_arbbb2chxtrgout
;# 		move y:(r2)-n2,y1 ; r2 = &F_arbbb2chxcmdgainuser
;# 		move y1,y:(r0)+n0 ; cmd to trgout (bit 19 important)
;# 				; r0 = skipped to &F_arbbb2chxgainuser
;# 		move a1,y:(r7)	; clear this command
;# 		move y:(r2)+,y1
;# 		move y1,y:(r0)+	 ; copy gainuser
;# 		move y:(r2)+,y1
;# 		move y1,y:(r0)+	 ; copy rngdac
;# 		jmp <F__arbbb2settrg

; IF WAIT FOR xeqcmdflg COMMAND FOR THIS CHANNEL AND xeqcmdflg SET
;   THEN DO COMMAND

;# F__arbbb2_xcmd1
;		JSETBUG with r1, y1
;		jclr #20,y:(r7),F__arbbb2_xcmd2
;	bit 20 of F_arbbb2chxcmd is set then an xeqcmdflg cmd
;# 		move y:(r7),b0
;# 		jclr #20,b0,F__arbbb2_xcmd2
;# 
;# 		jclr #23,y:<F_arbbb2xeqcmdflg,F__arbbb2_xcmd2
;# 	; if bit 23 set then is an xeqcmdflg cmd
;# 		jmp <F__arbbb2_icmd2
;# F__arbbb2_xcmd2

;;;;;;;  SET TRIGGER WORD
;
;	a is cleared
;	r7 points to F_arbbb2chxcmd
;	r1 points to F_arbbb2chxtrgout

;	set trigger if appropriate
F__arbbb2settrg	jclr #21,y:<Fsigoutcontrol,F__arbbb2settrgoff
;	no trigger out if not enabled
;		jclr #20,y:<F_arbbb2burstmode,F__arbbb2settrg1
				; no freerun trigger
;	clear freerun trigger request
;		bclr #20,y:<F_arbbb2burstmode
;		move y:<F_arbbb2trgon,y1
;		jmp <F__arbbb2settrg2

F__arbbb2settrg1
;		JSETBUG with r1, y1
;		jclr #19,y:(r1),F__arbbb2settrgoff ; no trigger out in cmd
;		move y:(r1),b0
;		jclr #19,b0,F__arbbb2settrgoff ; no trigger out in cmd

;	trigger is enabled and requested
F__arbbb2settrgon
;		 move y:<F_arbbb2trgon,y1
;		jmp <F__arbbb2settrg2
F__arbbb2settrgoff
;		 move y:<F_arbbb2trgoff,y1
F__arbbb2settrg2
;		move y1,y:<F_arbbb2trigoutwd
;		move a1,y:(r1)+		; clear trigger request

F__arbbb2_bursttest
	       jclr #1,y:<F_arbbb2burstmode,F__arbbb2_bursttestend
		; if burstzeroflg clr create a signal
		; if burstzeroflg set send zero to dac
F__arbbb2_zerosigout
		; zero in a1 sent to dac
		jmp <F__arbbb2_sigout
F__arbbb2_bursttestend

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; INTERPOLATION FILTERING
; POST FILTERING STATE MACHINE
		move y:<F_arbbb2poststatereg,r2
		nop
		move y:(r2)+,a0			; get next state
		move y:(r2),r2
			; get action routine
		move a0,y:<F_arbbb2poststatereg ; save next state
		jmp (r2)			; do it
;  look up pass

F__arbbb2pfltrnoinc move #255,m2		; set modulo 256 for r2
		move y:<F_arbbb2ptbl_actr,r2
		nop
		move y:(r2)+,b		; b1 points to state table
		tst b b1,r0		; r0 points to state table
		move y:<F_arbbb2ptbl_bctr,r2 ; look up next table
		jne <F__arbbb2ptbllu	; if b #0 lookup stat
		move y:(r2)+,r0		; r0 points to state table
		jmp <F__arbbb2ptbllu

F__arbbb2pfltr move #255,m2		; set modulo 256 for r2
		move y:<F_arbbb2ptbl_actr,r2
		nop
		move y:(r2)+,b		; b1 points to state table
		move r2,y:<F_arbbb2ptbl_actr ; save counter
		tst b b1,r0		; r0 points to state table
		move y:<F_arbbb2ptbl_bctr,r2 ; look up next table
		jne <F__arbbb2ptbllu	; if b #0 lookup stat
		move y:(r2)+,r0		; r0 points to state table
		move r2,y:<F_arbbb2ptbl_bctr ; save counter

F__arbbb2ptbllu
		move y:<F_arbbb2stchxos,n0 ; set ch offset
		move #$FFFF,m2	; set modulo to linear
		move (r0)+n0
		move y:(r0)+,r7
		nop
		jsr (r7)	; jump to real filter, getdata, skip ...
;		move y:(r0)+,r7
;		nop  
;		jsr (r7)	; jump to imag filter, getdata, skip ...

; POSTSCALE FILTER pass 0
F__arbbb2pass0	move #>F_arbbb2stch1_0r,r0
		move y:<F_arbbb2stchxos,n0
		nop
				; r0 points to states
		move (r0)+n0
		move y:(r0)+,r7
		nop  
		jsr (r7)	; jump to real filter, getdata, skip ...
;		move y:(r0)+,r7
;		nop  
;		jsr (r7)	; jump to imag filter, getdata, skip ...

; OUTPUT SIGNAL
;

;#	move y:(r2),y1  ; r2 points to data out
	move y:(r2),a  ; r2 points to data out

;#	y1 = real signal
;	a1 = real signal

;#	move  x:<F_arbbb2rampgainfactor,x1 ; IGNORE ASMBLR WARNING
					; x1 = upper 24 bits of ramp gain
;#	mpy	y1,x1,a

F__arbbb2_sigout
	move	y:<F_arbbb2bits,y0
	move	a1,x0
        mpy     y0,x0,a x:<F_arbbb2_txout,r2	; x0 is the shift factor
		; for DF1700 x0=$008000
			; shift 2 bytes so MSB is in last 16 bits of b1
                        ; the DF1700 takes last 16 bits msb first
		; for PCM63 x0=$080000
			; shift 3 bytes so MSB is in last 20 bits of b1
                        ; the PCM63 takes last 20 bits msb first
		; r2 loaded with address of SSI tx (x:Fdsp_tx) or
		;	a bit bucket (x:F_arbbb2txnull)
;        move    a1,y:<F_arbbb2sigout ; a1 = signal out, save it for debug

;	OUTPUT TRIGGER
;	       	move y:<F_arbbb2trigoutwd,y0
;		movep y0,x:<<Fdsp_crb
;		     The trigger out should only be sent by the xilinx
;		     based on edge of SC0. The SC0 output could hang
;		     indefinately if the last data out before frame sync off
;		     has trigger asserted.

; for debug clr testbit on trigger ;DEBUG
;		jset #0,y:<F_arbbb2trigoutwd,F__arbbb2notrgout ;DEBUG
;		movep #>$0,x:<<Fdsp_pcd ;DEBUG
;		jmp <F__arbbb2_sigout2 ;DEBUG
;
;F__arbbb2notrgout movep #>$2,x:<<Fdsp_pcd ;DEBUG

;	OUTPUT SIGNAL VALUE
F__arbbb2_sigout2
;	movep    a1,x:<<Fdsp_tx
		move y:<F_arbbb2chxptr,r1	; r1 = &F_arbbb2chxflgs
		move a1,x:(r2)

;	OUTPUT RANGE
;		JSETBUG with r1, y1
;		jclr #22,y:(r1),F__arbbb2_outrng1 ; ch1? yes ouput to rngwr
		move y:(r1),b0
		move b0,r2
		jclr #22,b0,F__arbbb2_outrng1 ; ch1? yes ouput to rngwr
		move y:<F_arbbb2ch2rngdac,y1
	       	movep    y1,y:<<Fsrc_rng2wr	; ch2 8 LSbits
		jmp F__arbbb2rtn
F__arbbb2_outrng1 move y:<F_arbbb2ch1rngdac,y1
		movep    y1,y:<<Fsrc_rngwr	; 8 LSbits

;	SETUP THE NEXT INTERRUPT
;	move lower 16 bits of F_arbbb2chxflgs to F_arbbb2chxptr
F__arbbb2rtn
		move r2,y:<F_arbbb2chxptr

		; set the time slice clock bit on the status word
		movep #>FSISR_TSCLK,y:<<Fsrc_sisr

;
;	!!! add restore of a few reg used by "calling" routine if needed
; r0, r1, r2
; a
; x0, y0
; n1
		move l:<F_usrbkgnd_a10,a10
		move y:<F_usrbkgnd_a2,a2
		move l:<F_usrbkgnd_x,x
		move l:<F_usrbkgnd_y,y
		move y:<F_usrbkgnd_r0,r0
		move x:<F_usrbkgnd_r1,r1
		move y:<F_usrbkgnd_r2,r2
		move y:<F_usrbkgnd_n1,n1
		move x:<F_usrbkgnd_m1,n2

;		move l:<F_usrbkgnd_b10,b10
;		move x:<F_usrbkgnd_b2,b2
;		move x:<F_usrbkgnd_r7,r7

;		movep #>$0,x:<<Fdsp_pcd ;DEBUG clear test bit when done

	rti	; F__arbbb2

F__arbbb2_sigoutmute

	clr a x:<F_arbbb2_txout,r2
		; r1 loaded with address of SSI tx (x:Fdsp_tx) or
		;	a bit bucket (x:F_arbbb2txnull)

;        move    a1,y:<F_arbbb2sigout ; a1 = signal out, save it for debug

;	OUTPUT TRIGGER
;	       	move y:<F_arbbb2trigoutwd,y0
;		movep y0,x:<<Fdsp_crb

;	OUTPUT SIGNAL VALUE
		move y:<F_arbbb2chxptr,r1	; r1 = &F_arbbb2chxflgs
		move a1,x:(r2)

;	OUTPUT MUTE RANGE

;		JSETBUG with r1, y1
;		jclr #22,y:(r1),F__arbbb2_sigoutm1 ; ch1? yes ouput to rngwr

		move y:(r1),b0
		move y:F_arbbb2rngmute,y1
		move b0,r2
		jclr #22,b0,F__arbbb2_sigoutm1 ; ch1? yes ouput to rngwr
	       	movep  y1,y:<<Fsrc_rng2wr	; ch2 8 LSbits
		jmp <F__arbbb2rtn

F__arbbb2_sigoutm1
		movep    y1,y:<<Fsrc_rngwr	; 8 LSbits
		jmp <F__arbbb2rtn

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; GET ARB SIGNAL


F__arbbb2getch2i
F__arbbb2getch2r
; set data chan bit for channel 2
		bset #FBUFR_DATA_CHAN_BIT,y:<F_arbbb2_srcbuffer_state 
		move y:<F_arbbb2ch2gaincorr,x0
		move y:<F_arbbb2ch2gainuser,y0
		jmp F__arbbb2getarbdata2
F__arbbb2getch1i
F__arbbb2getch1r
; clr data chan bit for channel 1
		bclr #FBUFR_DATA_CHAN_BIT,y:<F_arbbb2_srcbuffer_state 
		move y:<F_arbbb2ch1gaincorr,x0
		move y:<F_arbbb2ch1gainuser,y0
F__arbbb2getarbdata2


;	if srcbuffer_A (y:) active, go to F__arbbb2getarbx
	jset #FBUFRA_ACTIVE_BIT,y:<F_arbbb2_srcbuffer_state,F__arbbb2getarbx

;	if srcbuffer_B (y:) active, go to F__arbbb2getarby
	jset #FBUFRB_ACTIVE_BIT,y:<F_arbbb2_srcbuffer_state,F__arbbb2getarby

;	if neither are active output zero
	move #>0,x1
	jmp F__arbbb2getarbdata3

;;;;;;;;;;;;;;;;;;;;;; BUFFER A (also known as buffer x, in x memspace)
; in y space for srcusr

F__arbbb2getarbx
;	if bufrx read pointer > buferx end, go to F__arbbb2getarbx_end
	move y:<F_arbbb2_srcbuffer_x_ptr,a
	move y:<F_arbbb2_srcbuffer_x_end,b
	cmp b,a ; a-b
	jge F__arbbb2getarbx_end
	move a1,r7
	jmp F__arbbb2getarbx2

F__arbbb2getarbx1
;	if channel 2 don't switch buffers
	jset #FBUFR_DATA_CHAN_BIT,y:<F_arbbb2_srcbuffer_state,F__arbbb2getarbx1a
; do buffer switch on channel 1 only, to preserve interleaved data sync
	jclr #FBUFRSW2B_BIT,x:<F_arbbb2_bufrsw_flag,F__arbbb2getarbx1a
; switch to buffer B (y)
	bset #FBUFRB_ACTIVE_BIT,y:F_arbbb2_srcbuffer_state 
	bclr #FBUFRA_ACTIVE_BIT,y:F_arbbb2_srcbuffer_state 
	bset #FBUFRA_AVAIL_BIT,y:F_arbbb2_srcbuffer_state 
	bclr #FBUFRB_AVAIL_BIT,y:F_arbbb2_srcbuffer_state 
	move #>Fbufr_usry_base,b1
	move b1,y:>F_arbbb2_srcbuffer_y_ptr
; update sisr, clear flag
	clr b
	move 	b1,x:<F_arbbb2_bufrsw_flag
	move	y:<F_arbbb2_srcbuffer_state,b
	move	#>FBUFR_SISR_MASK,x0
	and	x0,b
	movep 	b1,y:<<Fsrc_sisr
	jmp F__arbbb2getarby1a

F__arbbb2getarbx1a
;	set pointer (r7) to the beginning of bufrx
	move #>Fbufr_usrx_base,r7
	nop

F__arbbb2getarbx2
;	load bufrx data into x1 and increment read pointer
;	move x:(r7)+,x1
	move y:(r7)+,x1 ; in y space for srcusr

;	save read pointer
	move r7,y:>F_arbbb2_srcbuffer_x_ptr

; 	go to F__arbbb2getarbdata3
	jmp F__arbbb2getarbdata3

F__arbbb2getarbx_end
;	if srcbuffer mode == CONTINUOUS go to F__arbbb2getarbx_endc
	jset #FSRCBUFFER_CONT_BIT,y:<F_arbbb2_srcbuffer_mode,F__arbbb2getarbx_endc
;	if srcbuffer mode == PERIODIC_AB go to F__arbbb2getarbx_endp
	jset #FSRCBUFFER_PER_AB_BIT,y:<F_arbbb2_srcbuffer_mode,F__arbbb2getarbx_endp

;	otherwise (PERIODIC_A or a SWITCHED MODE) loop on the buffer:
;	go to F__arbbb2getarbx1
	jmp F__arbbb2getarbx1

F__arbbb2getarbx_endc ; CONTINUOUS
;	if channel 2 don't switch buffers
	jset #FBUFR_DATA_CHAN_BIT,y:<F_arbbb2_srcbuffer_state,F__arbbb2getarbx_end2

;	if bufry is full, go to F__arbbb2getarby_swc
	jset #FBUFRB_FULL_BIT,y:<F_arbbb2_srcbuffer_state,F__arbbb2getarbx_swc

	jmp F__arbbb2getarbx_end2

F__arbbb2getarbx_endp ; PERIODIC_AB 
;	if channel 2 don't switch buffers
	jset #FBUFR_DATA_CHAN_BIT,y:<F_arbbb2_srcbuffer_state,F__arbbb2getarbx_end2

;	if bufry is full, go to F__arbbb2getarby_swp
	jset #FBUFRB_FULL_BIT,y:<F_arbbb2_srcbuffer_state,F__arbbb2getarbx_swp

F__arbbb2getarbx_end2
;	set FSISR_BUFERROR_BIT in SISR
	movep #>FSISR_BUFERROR,y:<<Fsrc_sisr

;	DON'T repeat buffer
;	go to F__arbbb2getarbx1
;	jmp F__arbbb2getarbx1

;	DO repeat last point
	move y:>F_arbbb2_srcbuffer_x_ptr,r7
	nop
	move (r7)-
	jclr #17,y:<Fsigoutcontrol,F__arbbb2getarbx2 ;single channel
	move (r7)-
	jmp F__arbbb2getarbx2

F__arbbb2getarbx_swc
;     set BUFRAVAIL_A bit in F_arbbb2_srcbuffer_state and SISR
	bclr #FBUFRA_FULL_BIT,y:F_arbbb2_srcbuffer_state 
	bset #FBUFRA_AVAIL_BIT,y:F_arbbb2_srcbuffer_state 
	movep #>FSISR_BUFRAVAIL_A,y:<<Fsrc_sisr
F__arbbb2getarbx_swp
	bset #FBUFRB_ACTIVE_BIT,y:F_arbbb2_srcbuffer_state 
	bclr #FBUFRA_ACTIVE_BIT,y:F_arbbb2_srcbuffer_state 

;     go to F__arbbb2getarby1
	jmp F__arbbb2getarby1a


;;;;;;;;;;;;;;;;;;;;;; BUFFER B (also known as buffer y, in y memspace)

F__arbbb2getarby
;	if bufry read pointer > bufery end, go to F__arbbb2getarby_end
	move y:<F_arbbb2_srcbuffer_y_ptr,a
	move y:<F_arbbb2_srcbuffer_y_end,b
	cmp b,a ; a-b
	jge F__arbbb2getarby_end
	move a1,r7
	jmp F__arbbb2getarby2

F__arbbb2getarby1
;	if channel 2 don't switch buffers
	jset #FBUFR_DATA_CHAN_BIT,y:<F_arbbb2_srcbuffer_state,F__arbbb2getarby1a
; do buffer switch on channel 1 only, to preserve interleaved data sync
	jclr #FBUFRSW2A_BIT,x:<F_arbbb2_bufrsw_flag,F__arbbb2getarby1a
; switch to buffer A (x)
	bset #FBUFRA_ACTIVE_BIT,y:F_arbbb2_srcbuffer_state 
	bclr #FBUFRB_ACTIVE_BIT,y:F_arbbb2_srcbuffer_state 
	bset #FBUFRB_AVAIL_BIT,y:F_arbbb2_srcbuffer_state 
	bclr #FBUFRA_AVAIL_BIT,y:F_arbbb2_srcbuffer_state 
	move #>Fbufr_usrx_base,b1
	move b1,y:>F_arbbb2_srcbuffer_x_ptr
	clr b
	move 	b1,x:<F_arbbb2_bufrsw_flag
	move	y:<F_arbbb2_srcbuffer_state,b
	move	#>FBUFR_SISR_MASK,x0
	and	x0,b
	movep 	b1,y:<<Fsrc_sisr
	jmp F__arbbb2getarbx1a

F__arbbb2getarby1a
;	set pointer (r7) to the beginning of bufry
	move #>Fbufr_usry_base,r7
	nop

F__arbbb2getarby2
;	load bufry data into x1 and increment read pointer
	move y:(r7)+,x1

;	save read pointer
	move r7,y:>F_arbbb2_srcbuffer_y_ptr

; 	go to F__arbbb2getarbdata3
	jmp F__arbbb2getarbdata3

F__arbbb2getarby_end
;	if srcbuffer mode == CONTINUOUS go to F__arbbb2getarby_endc
	jset #FSRCBUFFER_CONT_BIT,y:<F_arbbb2_srcbuffer_mode,F__arbbb2getarby_endc
;	if srcbuffer mode == PERIODIC_AB go to F__arbbb2getarby_endp
	jset #FSRCBUFFER_PER_AB_BIT,y:<F_arbbb2_srcbuffer_mode,F__arbbb2getarby_endp

;	otherwise (PERIODIC_A or a SWITCHED MODE) loop on the buffer:
;	go to F__arbbb2getarby1
	jmp F__arbbb2getarby1

F__arbbb2getarby_endc ; CONTINUOUS
;	if channel 2 don't switch buffers
	jset #FBUFR_DATA_CHAN_BIT,y:<F_arbbb2_srcbuffer_state,F__arbbb2getarby_end2

;	if bufrx is full, go to F__arbbb2getarby_swc
	jset #FBUFRA_FULL_BIT,y:<F_arbbb2_srcbuffer_state,F__arbbb2getarby_swc

	jmp F__arbbb2getarby_end2

F__arbbb2getarby_endp ; PERIODIC_AB 
;	if channel 2 don't switch buffers
	jset #FBUFR_DATA_CHAN_BIT,y:<F_arbbb2_srcbuffer_state,F__arbbb2getarby_end2

;	if bufrx is full, go to F__arbbb2getarby_swp
	jset #FBUFRA_FULL_BIT,y:<F_arbbb2_srcbuffer_state,F__arbbb2getarby_swp

F__arbbb2getarby_end2
;	set FSISR_BUFERROR bit in SISR
	movep #>FSISR_BUFERROR,y:<<Fsrc_sisr

;	DON'T repeat buffer
;	go to F__arbbb2getarby1
;	jmp F__arbbb2getarby1

;	DO repeat last point
	move y:>F_arbbb2_srcbuffer_y_ptr,r7
	nop
	move (r7)-
	jclr #17,y:<Fsigoutcontrol,F__arbbb2getarby2 ;single channel
	move (r7)-
	jmp F__arbbb2getarby2

F__arbbb2getarby_swc
;     set BUFRAVAIL_B bit in F_arbbb2_srcbuffer_state and SISR
	bclr #FBUFRB_FULL_BIT,y:F_arbbb2_srcbuffer_state 
	bset #FBUFRB_AVAIL_BIT,y:F_arbbb2_srcbuffer_state 
	movep #>FSISR_BUFRAVAIL_B,y:<<Fsrc_sisr
F__arbbb2getarby_swp
	bset #FBUFRA_ACTIVE_BIT,y:F_arbbb2_srcbuffer_state 
	bclr #FBUFRB_ACTIVE_BIT,y:F_arbbb2_srcbuffer_state 

;     go to F__arbbb2getarbx1
	jmp F__arbbb2getarbx1a

;;;;;;;;;;;;;;;;;;;;;;

F__arbbb2getarbdata3
		move y:(r0),r2		; move address of data in to r2
		move #12,n0		; r0 increment
		move (r2)+		; point r2 to data out
		move (r0)+n0 ; move r0 to the end so imaginary states are next
				; x1 = signal
				; x0 = gain correction
				; y0 = gain user
		mpy	x1,x0,a			
		move	a1,x1
		mpy	y0,x1,a
		move	a1,y:(r2) ;move data to data out
		rts  	; F__arbbb2getchxx, r2 points to data out

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; SKIP PASS

F__arbbb2skippass
		move #12,n0
		nop
		move (r0)+n0 ; move r0 to the end so imaginary states are next
		rts	; F__arbbb2skippass, r2 points to last data out
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   SSI xmit empty interrupt
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   
;   This routine can be in external p memory
;

F__arbbb2e	; DAC/DF overread error
;
	movep #>FSISR_OVERREAD,y:<<Fsrc_sisr  ; set bit indicating dac overread
	movep x:<<Fdsp_ssisr,a1	; clear exception
        ; Mute range dac immediately and turn signal off.  This
        ; is done in order to avoid channel swap in 2 channel mode.
        ; Do this even in 1 channel mode in order to be consistent.
        move y:F_arbbb2rngmute,y1
        movep y1,y:<<Fsrc_rngwr
        movep y1,y:<<Fsrc_rng2wr
        bset #23,y:<Fsigoutcontrol  ; immediate sigoff so that rang dacs
                                    ; won't get reset by dynamic commands
	jmp F__arbbb2

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;
;;;; WARNING: A dac over read error, when in 2 channel mode, even if only
;;;;          channel is on, has caused data from one channel being
;;;;          output to the wrong channel because of the loss of
;;;;	      synchronization and the serial buffering on the SSI port.
;;;;
;;;;	      When this occurs, last output value is repeated until a new
;;;;	      a new value is sent.  In one channel mode, the last value
;;;;	      is for the same (only) channel.  In 2 channel mode the
;;;;	      last value is from the other channel.  This can cause
;;;;	      unexpected large transcients in the output signal.
;;;;
;;;;          4/30/98 - In order to avoid the channel swap behaviour
;;;;          described above the output range dac's are now muted
;;;;          and the signal turned off as soon as an OVERREAD occurs.
;;;;          Even momentary channel swap glitches should NOT appear 
;;;;          on the output (for 16 bit mode) since the external digital 
;;;;          interpolation filters give enough group delay time for the 
;;;;          muting to occur before the glitch can get to the output.
;;;;          Turning the signal off suddenly should be better in most
;;;;          cases instead of risking the transients and effects from
;;;;          channel swap. 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Note: The frame sync (SC2) input can be read as bit PC5 of PCD
;	(port C data register) which may be helpful in determining
;	the current channel being output over the SSI (pg 11-1).
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Immediate commands
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

F__arbbb2_dyncmdch1 ; sets up recdata irq for dynmic cmd for ch 1
	move	(r6)+
        move    x0,y:(r6)+
        move    r2,y:(r6)+
        move    r7,y:(r6)+

; set write pointer to the beginning of dynamic cmd,r5
	move #>F_arbbb2ch1cmdgainuser,r5

F__arbbb2_dyncmdsu
; set irq routine to copy, r7
        move    #>F__arbbb2_dyncmd_firq,r7

F__arbbb2_dyncmdsu2
; /* copy fast interrupt routine to data interrupt F__hostrcvint */
        move    #>F_monv_hostrcvint,r2
        move    p:(r7)+,x0
        move    x0,p:(r2)+
        move    p:(r7)+,x0
        move    x0,p:(r2)+

; /* insure non modulo r5 */
	move #$ffffff,m5

        move    y:-(r6),r7
        move    y:-(r6),r2
	move	y:-(r6),x0
	move	(r6)-

	movep   #>FSISR_CMDACK,y:<<Fsrc_sisr  ; set cmd ack bit
	rti

F__arbbb2_dyncmdch2 ; sets up recdata irq for dynmic cmd for ch 2
	move	(r6)+
        move    x0,y:(r6)+
        move    r2,y:(r6)+
        move    r7,y:(r6)+

; set write pointer to the beginning of dynamic cmd,r5
	move #>F_arbbb2ch2cmdgainuser,r5
	jmp	<F__arbbb2_dyncmdsu
;;;;;;;;

F__arbbb2_dyncmdend ; sets up recdata irq for dynmic cmd for ch 1
	move	(r6)+
        move    x0,y:(r6)+
        move    r2,y:(r6)+
        move    r7,y:(r6)+

; set irq routine to copy, r7
        move    #>F__arbbb2_dyncmd_fnop,r7

	jmp	<F__arbbb2_dyncmdsu2
;;;;;;;;;

F__arbbb2_dyncmd_firq ; data rec fast interrupt routine dynamic cmd ch 1
	movep   x:<<Fdsp_hrx,y:(r5)+
	nop

F__arbbb2_dyncmd_fnop ; data rec fast interrupt routine dynamic cmd ch 1
	nop
	nop
;;;;;;;;;

F__arbbb2_x2b ; switch to buffer b (bufry)
	; set bufrsw_flag
	; update sisr, set ack
	bset 	#FBUFRSW2B_BIT,x:<F_arbbb2_bufrsw_flag
	movep   #>FSISR_CMDACK,y:<<Fsrc_sisr  ; set cmd ack bit
	rti

F__arbbb2_x2a ; switch to buffer a (bufrx)
	; set bufrsw_flag
	; update sisr, set ack
	bset 	#FBUFRSW2A_BIT,x:<F_arbbb2_bufrsw_flag
	movep   #>FSISR_CMDACK,y:<<Fsrc_sisr  ; set cmd ack bit
	rti

F__arbbb2_xferb_done ; sets bufry full
	; set B full, set ack
	bset #FBUFRB_FULL_BIT,y:<F_arbbb2_srcbuffer_state 
	movep   #>FSISR_CMDACK,y:<<Fsrc_sisr  ; set cmd ack bit
	rti

F__arbbb2_xfera_done ; sets bufrx full
		; set B full, set ack
	bset #FBUFRA_FULL_BIT,y:<F_arbbb2_srcbuffer_state 
	movep   #>FSISR_CMDACK,y:<<Fsrc_sisr  ; set cmd ack bit
	rti

F__arbbb2_xfera_setup ; sets up recdata irq for a (bufrx)
	;install data rec intr vector fast IRQ for A
	;clear A avail, set ack

	move	(r6)+
;##	move	b0,y:(r6)+
;##	move	b1,y:(r6)+
;##	move	b2,y:(r6)+
        move    x0,y:(r6)+
        move    r2,y:(r6)+
        move    r7,y:(r6)+

;##; /* disable host port receive and xmit interrupts */
;##; org_hcr = dsp_hcr;
;##; dsp_hcr = org_hcr & 0xfffffc;
;##        clr b
;##        move    x:Fdsp_hcr,b1
;##        move    #>$FFFFFC,x0
;##       and     x0,b
;##        move    b1,b
;##        move    b1,x:Fdsp_hcr

; /* copy fast interrupt routine to data interrupt F__hostrcvint */
        move    #>F__arbbb2_x_firq,r7
        move    #>F_monv_hostrcvint,r2
        move    p:(r7)+,x0
        move    x0,p:(r2)+
        move    p:(r7)+,x0
        move    x0,p:(r2)+

; /* insure non modulo r5 */
	move #$ffffff,m5

; set write pointer to the beginning, r5
	move #>Fbufr_usrx_base,r5
;	movep   r5,y:<<Fbufr_x_inptr ; not used any more

; set read pointer to the beginning
	move    r5,y:F_arbbb2_srcbuffer_x_ptr

;##; /* enable host port receive interrupts */
;##; dsp_hcr = org_hcr | 0x000001 ;
;##        clr b
;##        move    x:Fdsp_hcr,b1
;##        move    #>$1,x0
;##        or      x0,b
;##        move    b1,b
;##        move    b1,x:Fdsp_hcr

        move    y:-(r6),r7
        move    y:-(r6),r2
	move	y:-(r6),x0
;##	move	y:-(r6),b2
;##	move	y:-(r6),b1
;##	move	y:-(r6),b0
	move	(r6)-

	bclr #FBUFRA_AVAIL_BIT,y:<F_arbbb2_srcbuffer_state 
	movep   #>FSISR_CMDACK,y:<<Fsrc_sisr  ; set cmd ack bit

	rti

F__arbbb2_xferb_setup ; sets up recdata irq for b (bufry)
	;install data rec intr vector fast IRQ for A
	;clear A avail, set ack

	move	(r6)+
;##	move	b0,y:(r6)+
;##	move	b1,y:(r6)+
;##	move	b2,y:(r6)+
        move    x0,y:(r6)+
        move    r2,y:(r6)+
        move    r7,y:(r6)+

;##; /* disable host port receive and xmit interrupts */
;##; org_hcr = dsp_hcr;
;##; dsp_hcr = org_hcr & 0xfffffc;
;##        clr b
;##        move    x:Fdsp_hcr,b1
;##        move    #>$FFFFFC,x0
;##        and     x0,b
;##        move    b1,b
;##        move    b1,x:Fdsp_hcr

; /* copy fast interrupt routine to data interrupt F__hostrcvint */
        move    #>F__arbbb2_y_firq,r7
        move    #>F_monv_hostrcvint,r2
        move    p:(r7)+,x0
        move    x0,p:(r2)+
        move    p:(r7)+,x0
        move    x0,p:(r2)+

; /* insure non modulo r5 */
	move #$ffffff,m5

; set write pointer to the beginning,r5
	move #>Fbufr_usry_base,r5
;	movep   r5,y:<<Fbufr_y_inptr ; not used any more

; set read pointer to the beginning
	move    r5,y:F_arbbb2_srcbuffer_y_ptr

;##; /* enable host port receive interrupts */
;##; dsp_hcr = org_hcr | 0x000001 ;
;##        clr b
;##        move    x:Fdsp_hcr,b1
;##        move    #>$1,x0
;##        or      x0,b
;##        move    b1,b
;##        move    b1,x:Fdsp_hcr
;##
        move    y:-(r6),r7
        move    y:-(r6),r2
	move	y:-(r6),x0
;##	move	y:-(r6),b2
;##	move	y:-(r6),b1
;##	move	y:-(r6),b0
	move	(r6)-

	bclr #FBUFRB_AVAIL_BIT,y:<F_arbbb2_srcbuffer_state 
	movep   #>FSISR_CMDACK,y:<<Fsrc_sisr  ; set cmd ack bit
	rti


F__arbbb2_x_firq ; data rec fast interrupt routine, x: NOW y: in usr1.asm
	movep   x:<<Fdsp_hrx,y:(r5)+
;	movep   r5,y:<<Fbufr_x_inptr ; not used any more
	nop

F__arbbb2_y_firq ; data rec fast interrupt routine, y:
	movep   x:<<Fdsp_hrx,y:(r5)+
;	movep   r5,y:<<Fbufr_y_inptr ; not used any more
	nop

F__arbbb2_sisrupdate ; updates buffer available bits

	move	(r6)+
	; must bump stack pointer by one because it may be
	; pointing at the current not next available location
	move	b0,y:(r6)+
	move	b1,y:(r6)+
	move	b2,y:(r6)+
	move	x0,y:(r6)+
	
	move	y:<F_arbbb2_srcbuffer_state,b
	move	#>FBUFR_SISR_MASK,x0
	and	x0,b
	movep 	b1,y:<<Fsrc_sisr
	movep   #>FSISR_CMDACK,y:<<Fsrc_sisr  ; set cmd ack bit

	move	y:-(r6),x0
	move	y:-(r6),b2
	move	y:-(r6),b1
	move	y:-(r6),b0
	move	(r6)-
	rti
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

F__arbbb2bkgnd ; background routine if needed

; Background routine

; List registers that have to be stored in IRQ routines:
		rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

F__arbbb2_readxsetup
	; setup "on-the- fly" data read from x space
		; NOTE: x space below $5000 is shared with P space
		;       of system code.  Overwriting this area
		;	could cause problems if used by system code.

	; Protocol:
		; after init_measure (and manual arm if any)
		; send readxsetup command vector to dsp hostport
		; repeat the following for each data set read
		  ; send address to read from to dsp hostport data reg
		  ; read and discard first word from dsp hostport data reg
		  ; read desired # words from dsp hostport data reg

	; This mode is teminated by:
		; init_measure or reset_measure which calls
		  ; clari turn_off_source_finish which restores buffered
		  ; command mode
		; arb buffer write commands
		; dynamic parameter commands
		; readysetup command

	; To reduce the possibility of the signal generation falling out of
	; realtime, the data transfer is paced to no more than 16 words per
	; period of sample0 (see clari.c)

	; save registers used
	move	(r6)+
	move    x0,y:(r6)+
	move    r2,y:(r6)+
	move    r7,y:(r6)+

	; copy interrupt routine to write interrupt F__hostxmitint
	move    #>F__arbbb2_readx_data_firq,r7
	move    #>F_monv_hostxmitint,r2
	move    p:(r7)+,x0
	move    x0,p:(r2)+
	move    p:(r7)+,x0
	move    x0,p:(r2)+

	; copy interrupt routine to read interrupt F__hostrcvint
	move    #>F__arbbb2_readx_addr_firq,r7
	move    #>F_monv_hostrcvint,r2

F__arbbb2_readxsetup2
	move    p:(r7)+,x0
	move    x0,p:(r2)+
	move    p:(r7)+,x0
	move    x0,p:(r2)+

	; restore registers used
	move    y:-(r6),r7
	move    y:-(r6),r2
	move	y:-(r6),x0
	move	(r6)-

	; clear data in host port register
	movep   x:<<Fdsp_hrx,r4
	; next write to host port will set read address

	; clear modulo use of r4
	move  #$ffff,m4

	; preset address
	move  #$5000,r4

	; set cmd ack bit
	movep   #>FSISR_CMDACK,y:<<Fsrc_sisr  ; set cmd ack bit
	rti

F__arbbb2_readysetup
	; Same as _readxsetup, but for reading from y space
		; NOTE: see memory map for available addresses

	; save registers used
	move	(r6)+
	move    x0,y:(r6)+
	move    r2,y:(r6)+
	move    r7,y:(r6)+

	; copy interrupt routine to write interrupt F__hostxmitint
	move    #>F__arbbb2_ready_data_firq,r7
	move    #>F_monv_hostxmitint,r2
	move    p:(r7)+,x0
	move    x0,p:(r2)+
	move    p:(r7)+,x0
	move    x0,p:(r2)+

	; copy interrupt routine to read interrupt F__hostrcvint
	move    #>F__arbbb2_ready_addr_firq,r7
	move    #>F_monv_hostrcvint,r2
	jmp	F__arbbb2_readxsetup2

F__arbbb2_readx_addr_firq ; data rec fast interrupt routine
	movep   x:<<Fdsp_hrx,r4
	movep   x:(r4)+,x:<<Fdsp_htx

F__arbbb2_ready_addr_firq ; data rec fast interrupt routine
	movep   x:<<Fdsp_hrx,r4
	movep   y:(r4)+,x:<<Fdsp_htx

F__arbbb2_readx_data_firq ; data xmit fast interrupt routine
	movep   x:(r4)+,x:<<Fdsp_htx
	nop

F__arbbb2_ready_data_firq ; data xmit fast interrupt routine
	movep   y:(r4)+,x:<<Fdsp_htx
	nop

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

F__arbbb2_srcbuffer_init ; initialize srcbuffers

; Called from arbbb2m.c
; To be c callable, save and restore registers used
		jsr F__arbbb2_regallsave

; limit buffer size, calculate end and reset pointers
		move y:F_arbbb2_srcbuffer_x_size,b
		move y:F_arbbb2_srcbuffer_x_max,a
        	cmp b,a ; a-b
        	jgt F__arbbb2_srcbuffer_init01
		move a1,y:F_arbbb2_srcbuffer_x_size
		tfr a,b
		
F__arbbb2_srcbuffer_init01
		move #>Fbufr_usrx_base,a
		move a1,y:F_arbbb2_srcbuffer_x_ptr
		add a,b
		move b1,y:F_arbbb2_srcbuffer_x_end

		move y:F_arbbb2_srcbuffer_y_size,b
		move y:F_arbbb2_srcbuffer_y_max,a
        	cmp b,a ; a-b
        	jgt F__arbbb2_srcbuffer_init02
		move a1,y:F_arbbb2_srcbuffer_y_size
		tfr a,b

F__arbbb2_srcbuffer_init02
		move #>Fbufr_usry_base,a
		move a1,y:F_arbbb2_srcbuffer_y_ptr
		add a,b
		move b1,y:F_arbbb2_srcbuffer_y_end

; if srcbuffer_initmode != reset goto F__arbbb2bufinit_empty
	jclr #FSRCBUFFER_INIT_RESET_BIT,y:<F_arbbb2_srcbuffer_initmode,F__arbbb2bufinit_empty

; if periodic_a
		jclr #FSRCBUFFER_PER_A_BIT,y:<F_arbbb2_srcbuffer_mode,F__arbbb2_srcb_init1
; 	then set buffer a active, a full, a not available, and
;			b not active, b not full, b not available
		clr b
		bset #FBUFRA_ACTIVE_BIT,b1
		bset #FBUFRA_FULL_BIT,b1
		move b1,y:<F_arbbb2_srcbuffer_state
		jmp F__arbbb2_srcbuffer_init_end

F__arbbb2_srcb_init1
; if periodic_ab
		jclr #FSRCBUFFER_PER_AB_BIT,y:<F_arbbb2_srcbuffer_mode,F__arbbb2bufinit_empty
; 	then set buffer a active, a full, a not available,
;			b active, b full, b not available
		clr b
		bset #FBUFRA_ACTIVE_BIT,b1
		bset #FBUFRA_FULL_BIT,b1
		bset #FBUFRB_ACTIVE_BIT,b1
		bset #FBUFRB_FULL_BIT,b1
		move b1,y:<F_arbbb2_srcbuffer_state
		jmp F__arbbb2_srcbuffer_init_end

; else clear buffers

;;;;;;; EMPTY BUFFERS
F__arbbb2bufinit_empty
; do loop to clear bufrx
		clr b
		move	y:F_arbbb2_srcbuffer_x_max,r1
		move    #>Fbufr_usrx_base,r2
		do r1,F__arbbb2bufinit_srcbufrx1
		move	b1,y:(r2)+
F__arbbb2bufinit_srcbufrx1

; do loop to clear bufry
		move	y:F_arbbb2_srcbuffer_y_max,r1
		move    #>Fbufr_usry_base,r2
		do r1,F__arbbb2bufinit_srcbufry1
		move	b1,y:(r2)+
F__arbbb2bufinit_srcbufry1

; if periodic_a
		jclr #FSRCBUFFER_PER_A_BIT,y:<F_arbbb2_srcbuffer_mode,F__arbbb2_srcb_init2
; 	then set buffer a not active, a not full, a available, and
;			b not active, b not full, b not available
		clr b
		bset #FBUFRA_AVAIL_BIT,b1
		move b1,y:<F_arbbb2_srcbuffer_state
		jmp F__arbbb2_srcbuffer_init_end

F__arbbb2_srcb_init2
; 	set buffer a not active, a not full, a available, and
;		b not active, b not full, b available
		clr b
		bset #FBUFRA_AVAIL_BIT,b1
		bset #FBUFRB_AVAIL_BIT,b1
		move b1,y:<F_arbbb2_srcbuffer_state

F__arbbb2_srcbuffer_init_end
;		update buffer bits in sisr
		move	y:<F_arbbb2_srcbuffer_state,b
		move	#>FBUFR_SISR_MASK,x0
		and	x0,b
		movep 	b1,y:<<Fsrc_sisr

; To be c callable, save and restore registers
		jsr F__arbbb2_regallrestore

		rts
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
F__arbbb2_initvars
;;;;;;;;;;;;;;;;;;;;;; initalize variables
;
;;;;;;;;;;;;;;;;;;;;;; set general signal variables
;

; initialize gain correction factor based on var_src_acr
;  (high or lowband, cal ...)
		jsr Farbbb2gaincorr

; sigout variables:
		clr b
		move b0,y:<Fsigoutstatus
		move b0,y:<Fsigoutxeqcmdflg
		bclr #23,y:<Fsigoutcontrol  ; not immediate sigoff
		bclr #22,y:<Fsigoutcontrol  ; not ramping down

; clear accumulators, counters, and control flags

; F_arbbb2chnlflgs	; active channels set elsewhere
		move b0,y:<F_arbbb2chnlflgs

; F_arbbb2rampctl	dc	$000000	; Y
		move b0,y:<F_arbbb2rampctl

; if rampmode is continuous or burst the initialize for ramp up
;#		jset #23,y:<F_arbbb2rampmode,F__arbbb2_initvarscrampup ; cont
;#		jset #22,y:<F_arbbb2rampmode,F__arbbb2_initvarsbrampup ; burst
		move #>$7FFFFF,b1	; else init with gain factor of 1
		move #>$FFFFFF,b0
		move b,l:<F_arbbb2rampgainfactor
		clr b
;#			jmp F__arbbb2_initvars2

;#	F__arbbb2_initvarscrampup ; continuous (ramp up with start)
;#			bset #20,y:<F_arbbb2rampctl ; set start rampup
;#			jmp F__arbbb2_initvarsrampup
;#	F__arbbb2_initvarsbrampup ; block (ramp up after burst delay)
		bset #21,y:<F_arbbb2rampctl ; set rampup ok
;#	F__arbbb2_initvarsrampup	move b,l:<F_arbbb2rampgainfactor

F__arbbb2_initvars2
		bclr #20,y:<F_arbbb2burstmode ; clear freerun trigger request
		bclr #1,y:<F_arbbb2burstmode ; clear zero output

		move b,l:<F_arbbb2burstcounter
		move b,y:<F_arbbb2ch1trgout
		move b,y:<F_arbbb2ch2trgout

; clear signal
		clr b
		move b0,y:<F_arbbb2ch1signal
		move b0,y:<F_arbbb2ch2signal

		move b,y:<F_arbbb2ch1cmd ; clear any pending command
		move b,y:<F_arbbb2ch2cmd ; clear any pending command

; initialize command parameters with current values
; a command copies all parameters
		move y:<F_arbbb2ch1gainuser,y0
		move y0,y:<F_arbbb2ch1cmdgainuser
		move y:<F_arbbb2ch1rngdac,y0
		move y0,y:<F_arbbb2ch1cmdrngdac

		move y:<F_arbbb2ch2gainuser,y0
		move y0,y:<F_arbbb2ch2cmdgainuser
		move y:<F_arbbb2ch2rngdac,y0
		move y0,y:<F_arbbb2ch2cmdrngdac

		clr b
		move b0,y:<F_arbbb2trigoutwd
		move b0,y:F_arbbb2dfzeroctr

		bclr #23,y:<F_arbbb2burstmode ; turn off burst counter
		jclr #22,y:<F_arbbb2burstmode,F__arbbb2_initvarsnotburst
		bset #23,y:<F_arbbb2burstmode ; turn on burst counter
F__arbbb2_initvarsnotburst

		bset #21,y:<F_arbbb2burstmode ; init to freerun
		jclr #20,y:<Fsigoutcontrol,F__arbbb2_initvars_free ; freerun?
		bclr #21,y:<F_arbbb2burstmode ; no triggered
F__arbbb2_initvars_free

;;;;;;;;;;;;;;;;;;;;;; set signal variables based on HW DF in/out
;
		jclr #18,y:<Fsigoutcontrol,F__arbbb2_initvars_dfin ; is df1700 in?
		move #>FSIG_DFOUT_BITS,b0		; no, df1700 out
		move #>FSIG_DFOUT_DELAY,b1
		jmp F__arbbb2_initvars_dfset
F__arbbb2_initvars_dfin  move #>FSIG_DFIN_BITS,b0	; yes df1700 in
		move #>FSIG_DFIN_DELAY,b1
F__arbbb2_initvars_dfset move b0,y:<F_arbbb2bits
		move b1,y:F_arbbb2dfdelay

;;;;;;;;;;;;;;;;;;;;;; set signal variables based on single or dual channelmode
;
		move #>F_arbbb2ch1flgs,b0	; set pointer part
		move b0,y:<F_arbbb2ch2flgs
		bset #22,y:<F_arbbb2ch2flgs	; tag as channel 2
; dual ch mode?
		jset #17,y:<Fsigoutcontrol,F__arbbb2_initvars_dual
		move #>F_arbbb2ch1flgs,b0		; no, single
		move b0,y:<F_arbbb2ch1flgs	; set pointer par
		bclr #21,y:<F_arbbb2ch1flgs	; clr 2 ch mod bit
		bclr #21,y:<F_arbbb2ch2flgs
		move #>FCRB_XMIT1,b0
		move b0,y:<F_arbbb2trgoff
		move #>FCRB_XMIT1_TRG,b0
		move b0,y:<F_arbbb2trgon
		jmp F__arbbb2_initvars_ch1test

F__arbbb2_initvars_dual
		move #>F_arbbb2ch2flgs,b0	; dual channel
		move b0,y:<F_arbbb2ch1flgs	; set pointer part
		bset #21,y:<F_arbbb2ch1flgs	; set 2 ch mod bit
		bset #21,y:<F_arbbb2ch2flgs
		move #>FCRB_XMIT2,b0
		move b0,y:<F_arbbb2trgoff
		move #>FCRB_XMIT2_TRG,b0
		move b0,y:<F_arbbb2trgon
		move y:F_arbbb2dfdelay,b	; multiply DF delay by 2
		asl b
		move b1,y:F_arbbb2dfdelay

;;;;;;;;;;;;;;;;;;;;;; set signal variables based on ch1 and/or ch2 on
;
F__arbbb2_initvars_ch1test
		jset #16,y:<Fsigoutcontrol,F__arbbb2_initvars_ch1on ; is ch1 on?
		bclr #23,y:<F_arbbb2ch1flgs	; no
		jmp F__arbbb2_initvars_ch2test
F__arbbb2_initvars_ch1on bset #23,y:<F_arbbb2ch1flgs	; yes
		bset #21,y:<F_arbbb2chnlflgs
F__arbbb2_initvars_ch2test
		jset #15,y:<Fsigoutcontrol,F__arbbb2_initvars_ch2on ; is ch2 on?
		bclr #23,y:<F_arbbb2ch2flgs	; no
		jmp F__arbbb2_initvars_finish
F__arbbb2_initvars_ch2on bset #23,y:<F_arbbb2ch2flgs	; yes
		bset #20,y:<F_arbbb2chnlflgs

F__arbbb2_initvars_finish
		move #>F_arbbb2ch1flgs,b0
		move b0,y:<F_arbbb2chxptr

		rts ; F__arbbb2_initvars

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  INIT
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
F__arbbb2init

; 1. Initialize any signal generation variables based on setup
; 2. put the first data point in the dsp output register

; Variables set before calling:
;	used by arbbb2init:

;		Fsigoutcontrol
;
;		F_arbbb2rampmode
;		F_arbbb2rampgaindelta
;		F_arbbb2rampdownstart
;
;		F_arbbb2burstmode
;		F_arbbb2burstdelay
;		F_arbbb2burstend	
;		F_arbbb2holdoffend
;
;		F_arbbb2ch1gaincorr
;		F_arbbb2ch1gainuser
;		F_arbbb2ch1rngdac
;		F_arbbb2ch1seed
;		F_arbbb2ch1spanmode
;
;		F_arbbb2ch2gaincorr
;		F_arbbb2ch2gainuser
;		F_arbbb2ch2rngdac
;		F_arbbb2ch2seed
;		F_arbbb2ch2spanmode
;
;		F_arbbb2dfdelay
;		
;		
;		


; To be c callable, save and restore registers used
; Need to save all registers because the interrupt routine is called.



		jsr F__arbbb2_regallsave

		jclr #0,y:<Fsigoutcontrol,F__arbbb2init_start ;
;	arm

;		jset #1,y:<Fsigoutcontrol,F__arbbb2init_start
			; else skip resetting seed and
			; else skip resetting state tables and only calc next point
;	if not continuous reset things
		jclr #FSRCBUFFER_CONT_BIT,y:<F_arbbb2_srcbuffer_mode,F__arbbb2init_start

; set initialize values based on command parameters
; this prevents parameter reset on arm, insuring that a dynamic cmd
; parameter change is not missed.

		move y:<F_arbbb2ch1cmdgainuser,y0
		move y0,y:<F_arbbb2ch1gainuser
		move y:<F_arbbb2ch1cmdrngdac,y0
		move y0,y:<F_arbbb2ch1rngdac

		move y:<F_arbbb2ch2cmdgainuser,y0
		move y0,y:<F_arbbb2ch2gainuser
		move y:<F_arbbb2ch2cmdrngdac,y0
		move y0,y:<F_arbbb2ch2rngdac

;		jset #1,y:<Fsigoutcontrol,F__arbbb2init_start
			; else skip resetting seed and
			; else skip resetting state tables and only calc next point
;	if not continuous reset things
		jclr #FSRCBUFFER_CONT_BIT,y:<F_arbbb2_srcbuffer_mode,F__arbbb2init_start

F__arbbb2init_cont
		jsr F__arbbb2_initvars

;     save range dac values
		move    y:<F_arbbb2ch1rngdac,y1
		move    y1,y:F_arbbb2ch1rngtmp
		move    y:<F_arbbb2ch2rngdac,y1
		move    y1,y:F_arbbb2ch2rngtmp

;     mute range dacs
		move y:F_arbbb2rngmute,y1
		movep   y1,y:<<Fsrc_rngwr
		movep   y1,y:<<Fsrc_rng2wr
		move    y1,y:<F_arbbb2ch1rngdac
		move    y1,y:<F_arbbb2ch2rngdac
		jmp	F__arbbb2init_firstpt

F__arbbb2init_start
		jsr F__arbbb2_initvars

;     save range dac values
		move    y:<F_arbbb2ch1rngdac,y1
		move    y1,y:F_arbbb2ch1rngtmp
		move    y:<F_arbbb2ch2rngdac,y1
		move    y1,y:F_arbbb2ch2rngtmp

;     mute range dacs
		move y:F_arbbb2rngmute,y1
		movep   y1,y:<<Fsrc_rngwr
		movep   y1,y:<<Fsrc_rng2wr
		move    y1,y:<F_arbbb2ch1rngdac
		move    y1,y:<F_arbbb2ch2rngdac

F__arbbb2init_srcbuffer

; reset pointers
		move #>Fbufr_usrx_base,b
		move b1,y:F_arbbb2_srcbuffer_x_ptr
		move #>Fbufr_usry_base,b
		move b1,y:F_arbbb2_srcbuffer_y_ptr
; set a active
		bclr #FBUFRB_ACTIVE_BIT,y:<F_arbbb2_srcbuffer_state 
		bclr #FBUFRA_ACTIVE_BIT,y:<F_arbbb2_srcbuffer_state 

; if a full then set it active
		jclr #FBUFRA_FULL_BIT,y:<F_arbbb2_srcbuffer_state,F__arbbb2init_srcbuffer1
		bset #FBUFRA_ACTIVE_BIT,y:<F_arbbb2_srcbuffer_state 
F__arbbb2init_srcbuffer1
; update buffer bits in sisr
		move	y:<F_arbbb2_srcbuffer_state,b
		move	#>FBUFR_SISR_MASK,x0
		and	x0,b
		movep 	b1,y:<<Fsrc_sisr

; clear buffer switch pending flag
		clr b
		move b0,x:<F_arbbb2_bufrsw_flag

;;;;;;;;;;;;;;;;
; initialize state tables
;	routine = skip
;	data pointer = data in
;	filter coef = 2x
;	state variables = 0
;	output data = 0

F__arbbb2initfltrstcp0
	clr a
	move #>F__arbbb2skippass,x1	; skip routine
	move #>F_arbbb2mpass,x0	; 2x filter coeficents

;  channel 1  pass "17" thru 0, real and imag
	move    #>F_arbbb2stch1_17r,r2	;beginning of ch1 state table
	move 	#>F_arbbb2datach1_r-1,r1 ; pass data pointer
	move	#>F_arbbb2dataos,n1

	do #18,F__arbbb2initfltrstcp3 ; 0 thru 17 = 18
; real
	move	x1,y:(r2)+		; store filter pointer
	move	r1,y:(r2)+		; store input data pointer
	move	(r1)+
	move	a1,y:(r1)+n1		; clear output data
					; r1 -> imag pass n out data
	move	x0,y:(r2)+		; store filter coeficents
	do #10,F__arbbb2initfltrstcp1 ; zero filter states
	move a0,y:(r2)+
F__arbbb2initfltrstcp1 nop
; imag	
	move	(r1)-			; r1 -> imag pass n in data
	move	x1,y:(r2)+		; store filter pointer
	move	r1,y:(r2)+		; store input data pointer
	move	(r1)+
	move	a1,y:(r1)-n1		; clear output data
					; r1 -> real pass n out data
	move	x0,y:(r2)+		; store filter coeficents
	do #10,F__arbbb2initfltrstcp2 ; zero filter states
	move a0,y:(r2)+
F__arbbb2initfltrstcp2 nop
F__arbbb2initfltrstcp3 nop

;  channel 2  pass 17 thru 0, real and imag
	move    #>F_arbbb2stch2_17r,r2	;beginning of ch2 state table
	move 	#>F_arbbb2datach2_r-1,r1 ; pass data pointer

	do #18,F__arbbb2initfltrstcp6 ; 0 thru 17 = 18
; real
	move	x1,y:(r2)+		; store filter pointer
	move	r1,y:(r2)+		; store input data pointer
	move	(r1)+
	move	a1,y:(r1)+n1		; clear output data
					; r1 -> imag pass n out data
	move	x0,y:(r2)+		; store filter coeficents
	do #10,F__arbbb2initfltrstcp4 ; zero filter states
	move a0,y:(r2)+
F__arbbb2initfltrstcp4 nop
; imag	
	move	(r1)-			; r1 -> imag pass n in data
	move	x1,y:(r2)+		; store filter pointer
	move	r1,y:(r2)+		; store input data pointer
	move	(r1)+
	move	a1,y:(r1)-n1		; clear output data
					; r1 -> real pass n out data
	move	x0,y:(r2)+		; store filter coeficents
	do #10,F__arbbb2initfltrstcp5 ; zero filter states
	move a0,y:(r2)+
F__arbbb2initfltrstcp5 nop
F__arbbb2initfltrstcp6 nop

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Initialize pass 0 state machine and filter coefficients
; based on F_arbbb2spanmode
;;;;;;;;;;;;;;;;;;;;;;;;;
F__arbbb2initp0fltr
	move #>F_arbbb2poststate0_1,x1
	move x1,y:F_arbbb2poststatereg
	jset #23,y:F_arbbb2spanmode,F__arbbb2initp0fltr5
	jset #22,y:F_arbbb2spanmode,F__arbbb2initp0fltr4
;;;;;;;;;;;;;;;;;;;;;;;;;
; pass0 = 2x
;   set pass 0 filter coef pointers to 2x
;   2x filter coef already set
; Initialize pass 0 state table for postscale 2x
	move #>F_arbbb2poststate0_1a2,r2 ; 1 channel 2x
	jclr #17,y:<Fsigoutcontrol,F__arbbb2initp0fltrend ;single channel
	move #>F_arbbb2poststate0_1b2,r2 ; 2 channel 2x
	jmp F__arbbb2initp0fltrend
;;;;;;;;;;;;;;;;;;;;;;;;;
; pass0 = 4x
;   set pass 0 filter coef pointers to 4x
F__arbbb2initp0fltr4
	move #>F_arbbb2post4,x0
	move x0,y:F_arbbb2stch1_0r+2
	move x0,y:F_arbbb2stch1_0i+2
	move x0,y:F_arbbb2stch2_0r+2
	move x0,y:F_arbbb2stch2_0i+2
; Initialize pass 0 state table for postscale 4x
	move #>F_arbbb2poststate0_1a,r2 ; 1 channel 4x
	jclr #17,y:<Fsigoutcontrol,F__arbbb2initp0fltrend ;single channel
	move #>F_arbbb2poststate0_1b,r2 ; 2 channel 4x
	jmp F__arbbb2initp0fltrend
;;;;;;;;;;;;;;;;;;;;;;;;;
; pass0 = 5x
;   set pass 0 filter coef pointers to 5x
F__arbbb2initp0fltr5
	move #>F_arbbb2post5,x0
	move x0,y:F_arbbb2stch1_0r+2
	move x0,y:F_arbbb2stch1_0i+2
	move x0,y:F_arbbb2stch2_0r+2
	move x0,y:F_arbbb2stch2_0i+2
; Initialize pass 0 state table for postscale 5x
	move #>F_arbbb2poststate0_1c,r2 ; 1 channel 5x
	jclr #17,y:<Fsigoutcontrol,F__arbbb2initp0fltrend ;single channel
	move #>F_arbbb2poststate0_1d,r2 ; 2 channel 5x
F__arbbb2initp0fltrend
; Initialize pass 0 state table
	move #>F_arbbb2poststate0_1,r1
	do #20,F__arbbb2initp0fltrend2
	move p:(r2)+,x0
	move x0,y:(r1)+
F__arbbb2initp0fltrend2
	nop

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; extract max pass from F_arbbb2spanmode
	move y:F_arbbb2spanmode,a
	move #>$00001f,y1
	and y1,a
	move a1,y:F_arbbb2maxpass
	move y:F_arbbb2spanmode,a

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; for each pass set routine to getdata or real filter, or leave as skip
	clr a
	move #>17,a0		; pass counter
	move #>F__arbbb2_filter,x1	; filter routine
	move    #>F_arbbb2stch1_17r,r1	; beginning of ch1 state table
	move    #>F_arbbb2stch2_17r,r2	; beginning of ch2 state table
	move #>13,n1			; increment to next state
	move #>13,n2			; increment to next state
;  channel 1  pass "17" thru 0, real and imag
F__arbbb2initsetroutine0
	clr b
	move y:F_arbbb2maxpass,b0
	cmp b,a ; a-b
	jeq F__arbbb2initgetdata
	jlt F__arbbb2initfilterpass
;;;;;;;;;;;;;;;;
;  pass > maxpass then leave as skip
F__arbbb2initskip

	move (r1)+n1	; skip to ch1 imaginary state
	move (r1)+n1	; skip to ch1 next real state
	move (r2)+n2	; skip to ch2 imaginary state
	move (r2)+n2	; skip to ch2 next real state
	jmp F__arbbb2initsetroutinedec

;;;;;;;;;;;;;;;;
;  pass = maxpass then getdata
F__arbbb2initgetdata
	move #>F__arbbb2getch1r,x0
	move x0,y:(r1)+n1
	move #>F__arbbb2getch2r,x0
	move x0,y:(r2)+n2
	move (r1)+n1	; skip imag to ch1 next real state
	move (r2)+n2	; skip imag to ch2 next real state
	jmp F__arbbb2initsetroutinedec

;;;;;;;;;;;;;;;;
;  pass < maxpass then filter
F__arbbb2initfilterpass
	move #>F__arbbb2_filter,x0
	move x0,y:(r1)+n1
	move x0,y:(r2)+n2
	move (r1)+n1	; skip imag to ch1 next real state
	move (r2)+n2	; skip imag to ch2 next real state
;;;;;;
F__arbbb2initsetroutinedec
	dec a		; dec to next pass
	jge F__arbbb2initsetroutine0 ; continue
	; else done with routine pointer init

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; set r1 to point to proper preset table
	move y:F_arbbb2maxpass,x0
	move #>3,x1
	mpy x0,x1,a #>F_arbbb2preseta_0,x1
	asr a
	move a0,x0
	move x0,a
	add x1,a
	move a1,r1
;	jmp F__arbbb2init_preset
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Initialize pass tables counters
;   r1 points to entry in pass preset constants table
F__arbbb2init_preset nop
		move p:(r1)+,n2
		move #>F_arbbb2ptbl_a,r2
		nop
		move (r2)+n2
		move r2,y:F_arbbb2ptbl_actr
		move p:(r1)+,n2
		move #>F_arbbb2ptbl_b,r2
		nop
		move (r2)+n2
		move r2,y:F_arbbb2ptbl_bctr


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; calculate up to the sample BEFORE the first point
;   calculate preset table entry
F__arbbb2init_precalc
		move y:<F_arbbb2burstmode,a1
		move a1,y:F_arbbb2burstmodetmp
		move y:<F_arbbb2rampmode,a1
		move a1,y:F_arbbb2rampmodetmp
		clr a
		move a,l:F_arbbb2burstcounter
		move a1,y:<F_arbbb2rampmode ; init
		move a1,y:<F_arbbb2burstmode ; init
		bset #21,y:<F_arbbb2burstmode ; init to freerun

		move y:F_arbbb2maxpass,a0
		tst a
		jeq F__arbbb2init_precalcend ; full span
F__arbbb2init_precalc0_0
		dec a	; entry = (maxpass-1)*3 +F_arbbb2pprecount_0
F__arbbb2init_precalc0
		move a0,x0
		move #>3,x1
		mpy x0,x1,a
		asr a #>F_arbbb2pprecount_0,r1
		move a0,n1
		nop
		move (r1)+n1	
;   r1 now points to precount entry in pass preset constants table
;	both channels same span
;	2x calls of 2 channel mode
		clr a
		move p:(r1),a1 ; load precount entry
		move a1,y:F_arbbb2_precalc_a ; save for later

F__arbbb2init_precalc1
;	redirect output, don't write to the SSI until the first data point
;	(non flushable or overwriteable buffer)
		move #>F_arbbb2txnull,a0 ; point output to bit bucket
		move a0,x:<F_arbbb2_txout
	; set b1 based on postscale filtering
	;               b1 = 2x filter delay * postscale upsample
	;   if full postscale =2, b1 = 4.5 * 2  = 9
	;   if full postscale =4, b1 = 4.5 * 4 = 18
	;   if full postscale =5, b1 = 4.5 * 5 = 23
		clr b
		jset #23,y:F_arbbb2spanmode,F__arbbb2init_precalc1_p5
		jset #22,y:F_arbbb2spanmode,F__arbbb2init_precalc1_p4

	; pass0 = 2x
		move #>3,b1 ; ARB: postscale factor (2) * 1.5
;		move #>66,b1 ; RAND: postscale factor (2) * 1.5 * settling (22)
		move b1,y:F_arbbb2_precalc_b
		move #>0,b1 ;  ARB: postscale filter delay 0
;		move #>35,b1 ;  RAND: postscale filter delay (5) * settling (7)
		jmp F__arbbb2init_precalc2_0

F__arbbb2init_precalc1_p4 ; pass0 = 4x
		move #>8,b1 ; ARB: postscale factor (4) * 2
;		move #>144,b1 ; RAND: postscale factor (4) * 1.5 * settling (24)
		move b1,y:F_arbbb2_precalc_b
		move #>0,b1 ;  ARB: postscale filter delay 0
;		move #>98,b1 ;  RAND: postscale filter delay (14) * settling (7)
		jmp F__arbbb2init_precalc2_0

F__arbbb2init_precalc1_p5 ; pass0 = 5x
		move #>10,b1 ; ARB postscale factor (5) * 2
;		move #>170,b1 ; RAND: postscale factor (5) * 1.5 * settling (24)
		move b1,y:F_arbbb2_precalc_b
		move #>0,b1 ;  ARB: postscale filter delay 0
;		move #>119,b1 ;  RAND: postscale filter delay (17) * settling (7)

F__arbbb2init_precalc2_0
	; postscale filter delay

	; if bit 5 set dont settle digital filters
		jset #5,y:F_arbbb2spanmode,F__arbbb2init_precalcend

		tst b
		jeq F__arbbb2init_precalcend2_2
		do b1,F__arbbb2init_precalcend2_1
		jsr	F__arbbb2  ; returning via rti is okay.
		jsset #21,y:<F_arbbb2ch1flgs,F__arbbb2 ; if 2ch mode, repeat
		nop
		nop
F__arbbb2init_precalcend2_1
		nop
F__arbbb2init_precalcend2_2
	; interpolation filter delay
		move y:F_arbbb2_precalc_b,b1
			; b1 = postscale interpolation factor * interpolation filter delay
		do b1,F__arbbb2init_precalcend

		clr a
		move y:F_arbbb2_precalc_a,a0 ; interpolation factor
		tst a
		jle F__arbbb2init_precalcend1
		dec a
		jle F__arbbb2init_precalcend0_1 ; if F_arbbb2_precalc_a <= 1 do 1 loop
		; if F_arbbb2_precalc_a >1 do 2 loops
		move y:F_arbbb2_precalc_a,a1 ; interpolation factor
		do a1,F__arbbb2init_precalcend0
		jsr	F__arbbb2  ; returning via rti is okay.
		jsset #21,y:<F_arbbb2ch1flgs,F__arbbb2 ; if 2ch mode, repeat
		nop
		nop
F__arbbb2init_precalcend0
		nop
F__arbbb2init_precalcend0_1
		move y:F_arbbb2_precalc_a,a1 ; interpolation factor
		do a1,F__arbbb2init_precalcend0_2
		jsr	F__arbbb2  ; returning via rti is okay.
		jsset #21,y:<F_arbbb2ch1flgs,F__arbbb2 ; if 2ch mode, repeat
		nop
		nop
F__arbbb2init_precalcend0_2
		nop
F__arbbb2init_precalcend1
		nop
F__arbbb2init_precalcend
		nop

		move #>Fdsp_tx,b0 ; restore output pointer
		move b0,x:<F_arbbb2_txout

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; call F__arbbb2 to send first point (ch1) to the ssi outbuffer.
;	it also sets the ch1 range dac

F__arbbb2init_firstpt
;	set crb to set up proper mode for the SSI
		move y:<F_arbbb2trgoff,b0
		movep b0,x:<<Fdsp_crb
		jsr	F__arbbb2  ;returning via rti is okay.

F__arbbb2init_end
	;     restore burst and ramp values
		move y:F_arbbb2burstmodetmp,a1
		move a1,y:<F_arbbb2burstmode
		move y:F_arbbb2rampmodetmp,a1
		move a1,y:<F_arbbb2rampmode
	;     restore range dac values
		move    y:F_arbbb2ch1rngtmp,y1
		move    y1,y:<F_arbbb2ch1rngdac
		move    y:F_arbbb2ch2rngtmp,y1
		move    y1,y:<F_arbbb2ch2rngdac

; To be c callable, save and restore registers
		jsr F__arbbb2_regallrestore
	rts	; F__arbbb2init

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  RESET
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
F__arbbb2reset
;
;	single or dual channel based on sigout_reset setting of Fsigoutcontrol
;	continuous
;	full span
;	full scale amplitude
;	DF 1700 in, range dac set to 1Vpk (-19.875 of full scale).
;	rampgaindelta for 5 seconds ramptime
;
;	no rampup, no bust
;
;	registers used: b, y1, r1, r2
;


; To be c callable, save and restore registers used

		jsr F__arbbb2_regallsave

;	load interrupt vectors

	move #>F__arbbb2_irqs,r1
	move #>F_monv_ssixmitint,r2
	move p:(r1)+,x1
	move x1,p:(r2)+
	move p:(r1)+,x1
	move x1,p:(r2)+
	move p:(r1)+,x1
	move x1,p:(r2)+
	move p:(r1)+,x1
	move x1,p:(r2)+
	jmp F__arbbb2_resetvars

F__arbbb2_irqs
	jsr >F__arbbb2
	jsr >F__arbbb2e
;	jsr >F__arbbb2
;;;

F__arbbb2_resetvars
;	clear x:0, x:1
		clr b
		move b1,x:0
		move b1,x:1

; y:0 (Fsigoutstatus) and y:1 (Fsigoutcontrol) are cleared in sigout_reset

;	clear the rest of internal variable memory, L:$0002-L:$007F 

		move #>$000002,r2
		rep #126
		move b,l:(r2)+
	
;;;;;;;;;;;;;;;;;;;;;; set constant structure pointers
;
;F_arbbb2ch1cmdptr        dc      F_arbbb2ch1cmd ; Y:
		move #>F_arbbb2ch1cmd,b0
		move b0,y:<F_arbbb2ch1cmdptr

;F_arbbb2ch2cmdptr        dc      F_arbbb2ch2cmd ; Y:
		move #>F_arbbb2ch2cmd,b0
		move b0,y:<F_arbbb2ch2cmdptr

;;;;;;;;;;;;;;;;;;;;;; set constants
;
;F_arbbb2rngmute		dc $00007F ; rangedac mute
		move #>$0000EF,b0
		move b0,y:F_arbbb2rngmute

;;;;;;;;;;;;;;;;;;;;;; set default signal parameters
;
;F_arbbb2rampgaindelta    dc      $999999 ; L: long fract (48 bits)
;                                         L: x: = MSW, y: = LSW
;					  x = $000019
;		move #>$000019,b1
;		move #>$999999,b0
;	for clock of 51200, ramp delta = 1/(5*51200) = 1/256000
;				= .00000390625 = $000020 c49ba5
		move #>$000020,b1
		move #>$c49ba5,b0
		move b,l:<F_arbbb2rampgaindelta


;F_arbbb2rampgainfactor   dc      $FFFFFF ; L: nearly one $7FFFFF FFFFFF
                                        ; L: upper 24 in x = $7FFFFF
		move #>$7FFFFF,b1
		move #>$FFFFFF,b0
		move b,l:<F_arbbb2rampgainfactor
		move b,l:F_arbbb2longone

;F_arbbb2ch1gainuser      dc      $7FFFFF ; Y:
		move #>$7FFFFF,b0
		move b0,y:<F_arbbb2ch1gainuser
		move b0,y:<F_arbbb2ch2gainuser
		move b0,y:<F_arbbb2ch1cmdgainuser
		move b0,y:<F_arbbb2ch2cmdgainuser

;F_arbbb2ch1rngdac        dc      $000035 ; Y: 1 Vpk = -19.875 dB = $000035
		move #>$000035,b0
		move b0,y:<F_arbbb2ch1rngdac
		move b0,y:<F_arbbb2ch2rngdac
		move b0,y:<F_arbbb2ch1cmdrngdac
		move b0,y:<F_arbbb2ch2cmdrngdac

;F_arbbb2_txout
		move #>Fdsp_tx,b0
		move b0,x:<F_arbbb2_txout
;;;;;;;;;;;; arb buffer variables
; initilize source buffer max sizes
		move #1024,x1
		move x1,y:F_arbbb2_srcbuffer_y_size
		move x1,y:F_arbbb2_srcbuffer_x_size
		move #(Fbufr_x_top+1),b
		move #>Fbufr_usrx_base,x1
		sub x1,b
		move b1,y:F_arbbb2_srcbuffer_x_max
		move #(Fbufr_y_top+1),b
		move #>Fbufr_usry_base,x1
		sub x1,b
		move b1,y:F_arbbb2_srcbuffer_y_max
		move y:F_arbbb2_srcbuffer_x_size,x1
		move #>Fbufr_usrx_base,b
		move b1,y:F_arbbb2_srcbuffer_x_ptr
		add x1,b
		move b1,y:F_arbbb2_srcbuffer_x_end
		move y:F_arbbb2_srcbuffer_y_size,x1
		move #>Fbufr_usry_base,b
		move b1,y:F_arbbb2_srcbuffer_y_ptr
		add x1,b
		move b1,y:F_arbbb2_srcbuffer_y_end
		move #>FSRCBUFFER_MODE_DEF,b1
		move b1,y:F_arbbb2_srcbuffer_mode
		clr b
		move b1,y:<F_arbbb2_srcbuffer_state
		bset #FBUFRA_AVAIL_BIT,y:<F_arbbb2_srcbuffer_state 
		bset #FBUFRB_AVAIL_BIT,y:<F_arbbb2_srcbuffer_state 
		move #>FSRCBUFFER_INIT_EMPTY,b1
		move b1,y:F_arbbb2_srcbuffer_initmode
; do loop to clear bufrx
		clr b
		move	y:F_arbbb2_srcbuffer_x_max,r1
		move    #>Fbufr_usrx_base,r2
		do r1,F__arbbb2reset_srcbufrx1
		move	b1,y:(r2)+
F__arbbb2reset_srcbufrx1

; do loop to clear bufry
		move	y:F_arbbb2_srcbuffer_y_max,r1
		move    #>Fbufr_usry_base,r2
		do r1,F__arbbb2reset_srcbufry1
		move	b1,y:(r2)+
F__arbbb2reset_srcbufry1

; Copy filter coefficients to internal x
	move    #>F_arbbb2post4p,r1
	move    #>F_arbbb2post4,r2
	do #60,F__arbbb2fltrco1
	movem   p:(r1)+,x1
	move	x1,x:(r2)+
F__arbbb2fltrco1
	move    #>F_arbbb2post5p,r1
	move    #>F_arbbb2post5,r2
	do #60,F__arbbb2fltrco2
	movem   p:(r1)+,x1
	move	x1,x:(r2)+
F__arbbb2fltrco2
	move    #>F_arbbb2mpassp,r1
	move    #>F_arbbb2mpass,r2
	do #60,F__arbbb2fltrco3
	movem   p:(r1)+,x1
	move	x1,x:(r2)+
F__arbbb2fltrco3

; Copy the pass tables
F__arbbb2fltrptcp0
	move    #>F_arbbb2ptbl_ap,r1
	move    #>F_arbbb2ptbl_a,r2
	do #512,F__arbbb2fltrptcp1
	movem   p:(r1)+,x1
	move	x1,y:(r2)+
F__arbbb2fltrptcp1

; set default state tables
;	routine = skip
;	data pointer = data in
;	filter coef = 2x
;	state variables = 0
;	output data = 0
F__arbbb2fltrstcp0
	clr a
	move #>F__arbbb2skippass,x1	; skip routine
	move #>F_arbbb2mpass,x0		; 2x filter coeficents
	move #2,n1			; input to output offset
;  channel 1  pass "17" thru 0
	move    #>F_arbbb2stch1_17r,r2	;beginning of ch1 state table
	move 	#>F_arbbb2datach1_r-1,r1	; pass data pointer
	do #36,F__arbbb2fltrstcp2 ; 18*2= 36
	move	x1,y:(r2)+		; store filter pointer
	move	r1,y:(r2)+		; store input data pointer
	move	a1,y:(r1+n1)		; clear output data
	move	(r1)+
	move	x0,y:(r2)+		; store filter coeficents pointer
	do #10,F__arbbb2fltrstcp1 ; zero filter states
	move a0,y:(r2)+
F__arbbb2fltrstcp1 nop
F__arbbb2fltrstcp2 nop
;  channel 2  pass 17 thru 0
	move    #>F_arbbb2stch2_17r,r2	; beginning of ch2 state table
	move 	#>F_arbbb2datach2_r-1,r1	; pass data pointer
	do #36,F__arbbb2fltrstcp4 ; 18*2= 36
	move	x1,y:(r2)+		; store filter pointer
	move	r1,y:(r2)+		; store input data pointer
	move	a1,y:(r1+n1)		; clear output data
	move	(r1)+
	move	x0,y:(r2)+		; store filter coeficents pointer
	do #10,F__arbbb2fltrstcp3 ; zero filter states
	move a0,y:(r2)+
F__arbbb2fltrstcp3 nop
F__arbbb2fltrstcp4 nop

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Full span baseband
	clr a
	move a0,y:F_arbbb2spanmode

; set variables based on Fsigoutcontrol, etc
		jsr F__arbbb2_initvars

; To be c callable, save and restore registers
		jsr F__arbbb2_regallrestore
	rts	; F__arbbb2reset


;
;	fliter coefficients moved to internal x by reset
;
;---------------------------------------;
;  10th Order Elliptic Lowpass Filter	;
;	4x, postscaler			;
;  passband edge : 0.09765625 of Fs	;
;  stopband edge : 0.146484375 of Fs	;
;  ripple        : +0/-0.01 dB          ;
;  stopband atten: -110.0427 dB		;
;  coefficents				;
;---------------------------------------;
					; ------Section 1-
F_arbbb2post4p	dc	0.0354916    	; A1
         	dc	0.4757653    	; C  
     		dc     -0.7831376    	; B    
     		dc	0.4999999    	; A2E    
     		dc     -0.5994734    	; A2D    
     		dc	0.4999999    	; A2    
					; ------Section 2-
		dc	0.4266566    	; C  
    		dc	0.0894603    	; A1
     		dc     -0.7629465    	; B    
     		dc	0.4999999    	; A2E    
     		dc     -0.5449690    	; A2D    
     		dc	0.4999999    	; A2    
					; ------Section 3-
		dc	0.3737872    	; C  
    		dc	0.1101888    	; A1
     		dc     -0.7548145    	; B    
     		dc	0.4999999    	; A2E    
     		dc     -0.3940303    	; A2D    
     		dc	0.4999999    	; A2    
					; ------Section 4-             
         	dc	0.3226390    	; C  
    		dc	0.0875319    	; A1
     		dc     -0.7533445    	; B    
     		dc	0.4999999    	; A2E    
     		dc     -0.0114714    	; A2D    
     		dc	0.4999999    	; A2    
					; ------Section 5-
		dc	0.2891445    	; C  
    		dc	0.0479547*4    	; A1'
;			since only 1 of 4 inputs are none zero,  A1' = A1 * 4
     		dc     -0.7541006    	; B    
     		dc	0.4999999    	; A2E    
     		dc      0.7737799   	; A2D    
     		dc	0.4999999    	; A2    
					; ----------------

;---------------------------------------;
;  10th Order Elliptic Lowpass Filter	;
;	5x, postscaler			;
;  passband edge : 0.078125 of Fs	;
;  stopband edge : 0.1171875 of Fs	;
;  ripple        : +0/-0.01 dB          ;
;  stopband atten: -108.2181 dB		;
;  coefficents				;
;---------------------------------------;
					; ------Section 1-
F_arbbb2post5p	dc	0.0354735   	; A1
         	dc	0.4802872    	; C  
     		dc     -0.8547770    	; B    
     		dc	0.4999999    	; A2E    
     		dc     -0.7366979    	; A2D    
     		dc	0.4999999    	; A2    
					; ------Section 2-
		dc	0.4398175    	; C  
    		dc	0.0899066    	; A1
     		dc     -0.8323625    	; B    
     		dc	0.4999999    	; A2E    
     		dc     -0.6977729    	; A2D    
     		dc	0.4999999    	; A2    
					; ------Section 3-
		dc	0.3955683    	; C  
    		dc	0.1069911    	; A1
     		dc     -0.8169905    	; B    
     		dc	0.4999999    	; A2E    
     		dc     -0.5848429    	; A2D    
     		dc	0.4999999    	; A2    
					; ------Section 4-             
         	dc	0.3522180    	; C  
    		dc	0.0775019    	; A1
     		dc     -0.8062215    	; B    
     		dc	0.4999999    	; A2E    
     		dc     -0.2601891    	; A2D    
     		dc	0.4999999    	; A2    
					; ------Section 5-
		dc	0.3235888    	; C  
    		dc	0.0333010*5    	; A1'
;			since only 1 of 5 inputs are none zero,  A1' = A1 * 5
     		dc     -0.8002595    	; B    
     		dc	0.4999999    	; A2E    
     		dc      0.6491189   	; A2D    
     		dc	0.4999999    	; A2    
					; ----------------

;---------------------------------------;
;  8th Order Elliptic Lowpass Filter	;
;  in 10th Order Filter function	;
;	2x, multipass			;
;  passband edge : 0.1953125 of Fs	;
;  stopband edge : 0.29296875 of Fs	;
;  ripple        : +0/-0.01102584 dB    ;
;  stopband atten: -96 dB		;
;  coefficents				;
;---------------------------------------;
					; ------Section 1-
F_arbbb2mpassp	dc	0.0541295    	; A1
         	dc	0.4372871    	; C  
     		dc     -0.2537656    	; B    
     		dc	0.4999999    	; A2E    
     		dc      0.2818571    	; A2D    
     		dc	0.4999999    	; A2    
					; ------Section 2-
		dc	0.3181438    	; C  
    		dc	0.1358378    	; A1
     		dc     -0.2940181    	; B    
     		dc	0.4999999    	; A2E    
     		dc      0.4078847    	; A2D    
     		dc	0.4999999    	; A2    
					; ------Section 3-
		dc	0.2007574    	; C  
    		dc	0.1794851    	; A1
     		dc     -0.3761743    	; B    
     		dc	0.4999999    	; A2E    
     		dc      0.6665955    	; A2D    
     		dc	0.4999999    	; A2    
					; ------Section 4-             
         	dc	0.1170592    	; C  
    		dc	0.1595616    	; A1
     		dc     -0.4469378    	; B    
     		dc	0.4999999    	; A2E    
     		dc      0.9496368    	; A2D    
     		dc	0.4999999    	; A2    
					; ------Section 5-
;	since only 1 of 2 inputs are none zero, output =4*A1*A2= 2
		dc	0.0           	; C
    		dc	0.4999999      	; A1
     		dc      0.0          	; B    
     		dc	0.0          	; A2E    
     		dc      0.0         	; A2D    
     		dc	0.9999999    	; A2    
					; ----------------
; end filter coefficients

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; PASS TABLES
F_arbbb2ptbl_ap
F_arbbb2pstart_1p	dc	F_arbbb2stch1_1r
F_arbbb2pstart_2p	dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
F_arbbb2pstart_3p	dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
F_arbbb2pstart_4p	dc	F_arbbb2stch1_4r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
F_arbbb2pstart_5p	dc	F_arbbb2stch1_5r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_4r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
F_arbbb2pstart_6p	dc	F_arbbb2stch1_6r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_4r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_5r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_4r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
F_arbbb2pstart_7p	dc	F_arbbb2stch1_7r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_4r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_5r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_4r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_6r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_4r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_5r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_4r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
F_arbbb2pstart_8p	dc	F_arbbb2stch1_8r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_4r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_5r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_4r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_6r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_4r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_5r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_4r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_7r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_4r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_5r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_4r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_6r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_4r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_5r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_4r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_3r
			dc	F_arbbb2stch1_1r
			dc	F_arbbb2stch1_2r
			dc	F_arbbb2stch1_1r
F_arbbb2pstart_np	dc	$000000	;link to next table



F_arbbb2ptbl_bp
F_arbbb2pstart_9p	dc	F_arbbb2stch1_9r
F_arbbb2pstart_10p	dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
F_arbbb2pstart_11p	dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
F_arbbb2pstart_12p	dc	F_arbbb2stch1_12r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
F_arbbb2pstart_13p	dc	F_arbbb2stch1_13r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_12r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
F_arbbb2pstart_14p	dc	F_arbbb2stch1_14r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_12r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_13r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_12r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
F_arbbb2pstart_15p	dc	F_arbbb2stch1_15r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_12r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_13r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_12r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_14r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_12r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_13r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_12r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
F_arbbb2pstart_16p	dc	F_arbbb2stch1_16r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_12r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_13r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_12r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_14r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_12r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_13r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_12r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_15r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_12r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_13r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_12r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_14r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_12r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_13r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_12r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_11r
			dc	F_arbbb2stch1_9r
			dc	F_arbbb2stch1_10r
			dc	F_arbbb2stch1_9r
F_arbbb2pstart_17p	dc	F_arbbb2stch1_17r ;end table,skip or getdata


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; PASS PRESET CONSTANTS
F_arbbb2preseta_0	dc	0 ; pass 0 only no other passes
F_arbbb2presetb_0	dc	0
F_arbbb2pprecount_0	dc	0

F_arbbb2preseta_1	dc	F_arbbb2pstart_1p-F_arbbb2ptbl_ap
F_arbbb2presetb_1	dc	0
F_arbbb2pprecount_1	dc	1

F_arbbb2preseta_2	dc	F_arbbb2pstart_2p-F_arbbb2ptbl_ap
F_arbbb2presetb_2	dc	0
F_arbbb2pprecount_2	dc	2 ; (2^(n-1))-1 using a DO limiting to 65535

F_arbbb2preseta_3	dc	F_arbbb2pstart_3p-F_arbbb2ptbl_ap
F_arbbb2presetb_3	dc	0
F_arbbb2pprecount_3	dc	4

F_arbbb2preseta_4	dc	F_arbbb2pstart_4p-F_arbbb2ptbl_ap
F_arbbb2presetb_4	dc	0
F_arbbb2pprecount_4	dc	8

F_arbbb2preseta_5	dc	F_arbbb2pstart_5p-F_arbbb2ptbl_ap
F_arbbb2presetb_5	dc	0
F_arbbb2pprecount_5	dc	16

F_arbbb2preseta_6	dc	F_arbbb2pstart_6p-F_arbbb2ptbl_ap
F_arbbb2presetb_6	dc	0
F_arbbb2pprecount_6	dc	32

F_arbbb2preseta_7	dc	F_arbbb2pstart_7p-F_arbbb2ptbl_ap
F_arbbb2presetb_7	dc	0
F_arbbb2pprecount_7	dc	64

F_arbbb2preseta_8	dc	F_arbbb2pstart_8p-F_arbbb2ptbl_ap
F_arbbb2presetb_8	dc	0
F_arbbb2pprecount_8	dc	128

F_arbbb2preseta_9	dc	F_arbbb2pstart_np-F_arbbb2ptbl_ap
F_arbbb2presetb_9	dc	F_arbbb2pstart_9p-F_arbbb2ptbl_bp
F_arbbb2pprecount_9	dc	256

F_arbbb2preseta_10	dc	F_arbbb2pstart_np-F_arbbb2ptbl_ap
F_arbbb2presetb_10	dc	F_arbbb2pstart_10p-F_arbbb2ptbl_bp
F_arbbb2pprecount_10	dc	512

F_arbbb2preseta_11	dc	F_arbbb2pstart_np-F_arbbb2ptbl_ap
F_arbbb2presetb_11	dc	F_arbbb2pstart_11p-F_arbbb2ptbl_bp
F_arbbb2pprecount_11	dc	1024

F_arbbb2preseta_12	dc	F_arbbb2pstart_np-F_arbbb2ptbl_ap
F_arbbb2presetb_12	dc	F_arbbb2pstart_12p-F_arbbb2ptbl_bp
F_arbbb2pprecount_12	dc	2048

F_arbbb2preseta_13	dc	F_arbbb2pstart_np-F_arbbb2pstart_1p
F_arbbb2presetb_13	dc	F_arbbb2pstart_13p-F_arbbb2ptbl_bp
F_arbbb2pprecount_13	dc	4096

F_arbbb2preseta_14	dc	F_arbbb2pstart_np-F_arbbb2ptbl_ap
F_arbbb2presetb_14	dc	F_arbbb2pstart_14p-F_arbbb2ptbl_bp
F_arbbb2pprecount_14	dc	8192

F_arbbb2preseta_15	dc	F_arbbb2pstart_np-F_arbbb2ptbl_ap
F_arbbb2presetb_15	dc	F_arbbb2pstart_15p-F_arbbb2ptbl_bp
F_arbbb2pprecount_15	dc	16384

F_arbbb2preseta_16	dc	F_arbbb2pstart_np-F_arbbb2ptbl_ap
F_arbbb2presetb_16	dc	F_arbbb2pstart_16p-F_arbbb2ptbl_bp
F_arbbb2pprecount_16	dc	32768

F_arbbb2preseta_17	dc	F_arbbb2pstart_np-F_arbbb2ptbl_ap
F_arbbb2presetb_17	dc	F_arbbb2pstart_17p-F_arbbb2ptbl_bp
F_arbbb2pprecount_17	dc	65535

;	postfilter pass states: 1 channel, postscale 2x
F_arbbb2poststate0_1a2	dc      F_arbbb2poststate1_1	; next state
			dc      F__arbbb2pfltr		; ch1 action
F_arbbb2poststate0_2a2	dc      0			; next state
			dc      0			; ch2 action
F_arbbb2poststate1_1a2	dc      F_arbbb2poststate0_1	; next state
			dc      F__arbbb2pfltr		; ch1 action
F_arbbb2poststate1_2a2	dc      0			; next state
			dc      0			; ch2 action
F_arbbb2poststate2_1a2	dc      0			; next state
			dc      0			; ch1 action
F_arbbb2poststate2_2a2	dc      0			; next state
			dc      0			; ch2 action
F_arbbb2poststate3_1a2	dc      0			; next state
			dc      0			; ch1 action
F_arbbb2poststate3_2a2	dc      0			; next state
			dc      0			; ch2 action
F_arbbb2poststate4_1a2	dc      0			; next state
			dc      0			; ch2 action
F_arbbb2poststate4_2a2	dc      0			; next state
			dc      0			; ch2 action

;	postfilter pass states: 2 channel, postscale 2x
F_arbbb2poststate0_1b2	dc      F_arbbb2poststate0_2	; next state
			dc      F__arbbb2pfltrnoinc	; ch1 action
F_arbbb2poststate0_2b2	dc      F_arbbb2poststate1_1	; next state
			dc      F__arbbb2pfltr		; ch2 action
F_arbbb2poststate1_1b2	dc      F_arbbb2poststate1_2	; next state
			dc      F__arbbb2pfltrnoinc	; ch1 action
F_arbbb2poststate1_2b2	dc      F_arbbb2poststate0_1	; next state
			dc      F__arbbb2pfltr		; ch2 action
F_arbbb2poststate2_1b2	dc      0			; next state
			dc      0			; ch1 action
F_arbbb2poststate2_2b2	dc      0			; next state
			dc      0			; ch2 action
F_arbbb2poststate3_1b2	dc      0			; next state
			dc      0			; ch1 action
F_arbbb2poststate3_2b2	dc      0			; next state
			dc      0			; ch2 action
F_arbbb2poststate4_1b2	dc      0			; next state
			dc      0			; ch2 action
F_arbbb2poststate4_2b2	dc      0			; next state
			dc      0			; ch2 action


;	postfilter pass states: 1 channel, postscale 4x
F_arbbb2poststate0_1a	dc      F_arbbb2poststate1_1	; next state
			dc      F__arbbb2pass0		; ch1 action
F_arbbb2poststate0_2a	dc      0			; next state
			dc      0			; ch2 action
F_arbbb2poststate1_1a	dc      F_arbbb2poststate2_1	; next state
			dc      F__arbbb2pass0		; ch1 action
F_arbbb2poststate1_2a	dc      0			; next state
			dc      0			; ch2 action
F_arbbb2poststate2_1a	dc      F_arbbb2poststate3_1	; next state
			dc      F__arbbb2pfltr		; ch1 action
F_arbbb2poststate2_2a	dc      0			; next state
			dc      0			; ch2 action
F_arbbb2poststate3_1a	dc      F_arbbb2poststate0_1	; next state
			dc      F__arbbb2pfltr		; ch1 action
F_arbbb2poststate3_2a	dc      0			; next state
			dc      0			; ch2 action
F_arbbb2poststate4_1a	dc      0			; next state
			dc      0			; ch2 action
F_arbbb2poststate4_2a	dc      0			; next state
			dc      0			; ch2 action

;	postfilter pass states: 2 channel, postscale 4x
F_arbbb2poststate0_1b	dc      F_arbbb2poststate0_2	; next state
			dc      F__arbbb2pass0		; ch1 action
F_arbbb2poststate0_2b	dc      F_arbbb2poststate1_1	; next state
			dc      F__arbbb2pass0		; ch2 action
F_arbbb2poststate1_1b	dc      F_arbbb2poststate1_2	; next state
			dc      F__arbbb2pass0		; ch1 action
F_arbbb2poststate1_2b	dc      F_arbbb2poststate2_1	; next state
			dc      F__arbbb2pass0		; ch2 action
F_arbbb2poststate2_1b	dc      F_arbbb2poststate2_2	; next state
			dc      F__arbbb2pfltrnoinc	; ch1 action
F_arbbb2poststate2_2b	dc      F_arbbb2poststate3_1	; next state
			dc      F__arbbb2pfltr		; ch2 action
F_arbbb2poststate3_1b	dc      F_arbbb2poststate3_2	; next state
			dc      F__arbbb2pfltrnoinc	; ch1 action
F_arbbb2poststate3_2b	dc      F_arbbb2poststate0_1	; next state
			dc      F__arbbb2pfltr		; ch2 action
F_arbbb2poststate4_1b	dc      0			; next state
			dc      0			; ch2 action
F_arbbb2poststate4_2b	dc      0			; next state
			dc      0			; ch2 action

;	postfilter pass states: 1 channel, postscale 5x
F_arbbb2poststate0_1c	dc      F_arbbb2poststate1_1	; next state
			dc      F__arbbb2pass0		; ch1 action
F_arbbb2poststate0_2c	dc      0			; next state
			dc      0			; ch2 action
F_arbbb2poststate1_1c	dc      F_arbbb2poststate2_1	; next state
			dc      F__arbbb2pass0		; ch1 action
F_arbbb2poststate1_2c	dc      0			; next state
			dc      0 			; ch2 action
F_arbbb2poststate2_1c	dc      F_arbbb2poststate3_1	; next state
			dc      F__arbbb2pass0		; ch1 action
F_arbbb2poststate2_2c	dc      0			; next state
			dc      0			; ch2 action
F_arbbb2poststate3_1c	dc      F_arbbb2poststate4_1	; next state
			dc      F__arbbb2pfltr		; ch1 action
F_arbbb2poststate3_2c	dc      0			; next state
			dc      0			; ch2 action
F_arbbb2poststate4_1c	dc      F_arbbb2poststate0_1	; next state
			dc      F__arbbb2pfltr		; ch1 action
F_arbbb2poststate4_2c	dc      0			; next state
			dc      0			; ch2 action

;	postfilter pass states: 2 channel, postscale 5x
F_arbbb2poststate0_1d	dc      F_arbbb2poststate0_2	; next state
			dc      F__arbbb2pass0		; ch1 action
F_arbbb2poststate0_2d	dc      F_arbbb2poststate1_1	; next state
			dc      F__arbbb2pass0		; ch2 action
F_arbbb2poststate1_1d	dc      F_arbbb2poststate1_2	; next state
			dc      F__arbbb2pass0		; ch1 action
F_arbbb2poststate1_2d	dc      F_arbbb2poststate2_1	; next state
			dc      F__arbbb2pass0		; ch2 action
F_arbbb2poststate2_1d	dc      F_arbbb2poststate2_2	; next state
			dc      F__arbbb2pass0		; ch1 action
F_arbbb2poststate2_2d	dc      F_arbbb2poststate3_1	; next state
			dc      F__arbbb2pass0		; ch2 action
F_arbbb2poststate3_1d	dc      F_arbbb2poststate3_2	; next state
			dc      F__arbbb2pfltrnoinc	; ch1 action
F_arbbb2poststate3_2d	dc      F_arbbb2poststate4_1	; next state
			dc      F__arbbb2pfltr		; ch2 action
F_arbbb2poststate4_1d	dc      F_arbbb2poststate4_2	; next state
			dc      F__arbbb2pfltrnoinc	; ch1 action
F_arbbb2poststate4_2d	dc      F_arbbb2poststate0_1	; next state
			dc      F__arbbb2pfltr		; ch2 action

F__arbbb2_regallsave
; Save all registers
; Once saved, registers may be used by assembly interrupt routine
;      Specific interrupt routines can get by adjusting the stack pointer,
;      r6, and saving only those registers used
;
; A full context save and restore is 59 instructions with added time for
; wait states when accessing external P and Y memory.
;
; Saving SSL and SSL in a sub routine would save the wrong values unless
; the stack is messed with.  This means that when using these routines
; the stack is not expanded.  The stack is only 16 deep so be careful.
;
	move	(r6)+
	; must bump stack pointer by one because it may be
	; pointing at the current not next available location
	move	r0,y:(r6)+
	move	r1,y:(r6)+
	move	r2,y:(r6)+
	move	r7,y:(r6)+
	move	b0,y:(r6)+
	move	b1,y:(r6)+
	move	b2,y:(r6)+
	move	x0,y:(r6)+
	move	x1,y:(r6)+
	move	y0,y:(r6)+
	move	y1,y:(r6)+
	move	n0,y:(r6)+
	move	n1,y:(r6)+
	move	n2,y:(r6)+
	move	n6,y:(r6)+
	move	n7,y:(r6)+
	move	m0,y:(r6)+
	move	m1,y:(r6)+
	move	m2,y:(r6)+
;	move	m6,y:(r6)+
	move	m7,y:(r6)+
	move	a0,y:(r6)+
	move	a1,y:(r6)+
	move	a2,y:(r6)+
; need to initialize used m registers since an assembler routine could
; be interrupted that may have changed them
	move	#$FFFF,m0
	move	#$FFFF,m1
	move	#$FFFF,m2
;	move	#$FFFF,m6
	move	#$FFFF,m7
	rti	; F__arbbb2_regallsave

F__arbbb2_regallrestore
; Restore all registers
	move	y:-(r6),a2
	move	y:-(r6),a1
	move	y:-(r6),a0
	move	y:-(r6),m7
;	move	y:-(r6),m6
	move	y:-(r6),m2
	move	y:-(r6),m1
	move	y:-(r6),m0
	move	y:-(r6),n7
	move	y:-(r6),n6
	move	y:-(r6),n2
	move	y:-(r6),n1
	move	y:-(r6),n0
	move	y:-(r6),y1
	move	y:-(r6),y0
	move	y:-(r6),x1
	move	y:-(r6),x0
	move	y:-(r6),b2
	move	y:-(r6),b1
	move	y:-(r6),b0
	move	y:-(r6),r7
	move	y:-(r6),r2
	move	y:-(r6),r1
	move	y:-(r6),r0
	move	(r6)-
	rti	; F__arbbb2_regallrestore

Farbbb2cmd
	move	r0,y:(r6)+
	move	ssh,y:(r6)+
	move	#2,n6
	move	r6,r0
	move	(r6)+n6
	move	b0,y:(r6)+
	move	b1,y:(r6)+
	move	r1,y:(r6)+
; **************************************************
; /* derived from: arbbb2m.c.ux,v 1.3 95/10/31 12:31:40 donm Exp $ */
; 
; #include "page.h"
; 
; #include "bufrs.h"
; 
; #include "hwaddr.h"
; #include "moncmda.h"
; #include "bdparms.h"
; 
; #define		ARBBB2_CH1CMD		0x800031
; #define		ARBBB2_CH2CMD		0x800032
; #define		ARBBB2_SETUP		0x800033
; #define         ARBBB2_BUFRSETUP        0x800034
; #define         ARBBB2_BUFRMAXRD        0x800035
; 
; extern volatile unsigned	_arbbb2rampmode;
; extern volatile unsigned	_arbbb2rampgaindelta;
; extern volatile unsigned	_arbbb2rampdownstart;
; extern volatile unsigned	_arbbb2burstmode;
; extern volatile unsigned	_arbbb2burstdelay;
; extern volatile unsigned	_arbbb2burstend;	
; extern volatile unsigned	_arbbb2holdoffend;
; extern volatile unsigned	_arbbb2ch1gaincorr;
; extern volatile unsigned	_arbbb2ch1gainuser;
; extern volatile unsigned	_arbbb2ch1rngdac;
; extern volatile unsigned	_arbbb2ch2gaincorr;
; extern volatile unsigned	_arbbb2ch2gainuser;
; extern volatile unsigned	_arbbb2ch2rngdac;
; extern volatile unsigned	_arbbb2dfdelay;
; extern volatile unsigned	_arbbb2ch1cmdgainuser;
; extern volatile unsigned	_arbbb2ch1cmdrngdac;
; extern volatile unsigned	_arbbb2ch1cmd;
; extern volatile unsigned	_arbbb2ch2cmdgainuser;
; extern volatile unsigned	_arbbb2ch2cmdrngdac;
; extern volatile unsigned	_arbbb2ch2cmd;
; extern volatile unsigned	_arbbb2spanmode;
; extern volatile unsigned	_arbbb2_srcbuffer_x_max;
; extern volatile unsigned	_arbbb2_srcbuffer_y_max;
; extern volatile unsigned	_arbbb2_srcbuffer_x_size;
; extern volatile unsigned	_arbbb2_srcbuffer_y_size;
; extern volatile unsigned	_arbbb2_srcbuffer_initmode;
; extern volatile unsigned	_arbbb2_srcbuffer_mode;
; extern volatile unsigned	__arbbb2_srcbuffer_init();
; 
; void
; arbbb2cmd(unsigned extcmd)		/*______*/
; /* arbbb2 extended messages */
; /* test passes command then do the appropriate extended message */
; 
; /* WARNING: the # of cases in a switch statement must be limited to
;    3 or less to avoid creating a jmp table in y mem.  This use
;    of initilized y memory is incompatible with this overlayed code */
; 
; {
;     unsigned msw, temp0;
;     switch (extcmd){
; **************************************************
	move	#-3,n0
	move	#>8388658,b
	move	y:(r0+n0),a
	move	#0,a2
	move	#0,b2
	cmp	b,a
	jeq	L4
	move	#>8388658,b
	move	#0,a2
	move	#0,b2
	cmp	b,a
	jgt	L8
	move	#>8388657,b
	move	#0,a2
	move	#0,b2
	cmp	b,a
	jeq	L3
	jmp	L7
L8
	move	#>8388659,b
	move	#0,a2
	move	#0,b2
	cmp	b,a
	jeq	L5
	jmp	L7
L3
; **************************************************
; 
;   case ARBBB2_CH1CMD:
;       /* read in channel 1 dynamic parameters */
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2ch1cmdgainuser);
; **************************************************
	move	#>F_arbbb2ch1cmdgainuser,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2ch1cmdrngdac);
; **************************************************
	move	#>F_arbbb2ch1cmdrngdac,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2ch1cmd);
; **************************************************
	move	#>F_arbbb2ch1cmd,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       break;
; **************************************************
	jmp	L2
L4
; **************************************************
; 
;   case ARBBB2_CH2CMD:
;       /* read in channel 2 dynamic parameters */
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2ch2cmdgainuser);
; **************************************************
	move	#>F_arbbb2ch2cmdgainuser,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2ch2cmdrngdac);
; **************************************************
	move	#>F_arbbb2ch2cmdrngdac,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2ch2cmd);
; **************************************************
	move	#>F_arbbb2ch2cmd,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       break;
; **************************************************
	jmp	L2
L5
; **************************************************
; 
;   case ARBBB2_SETUP:
;       /* read in setup parameters */
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2rampmode);
; **************************************************
	move	#>F_arbbb2rampmode,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, &msw);	/* msw first, in x: */
; **************************************************
	move	r0,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       memwritex((unsigned*)&_arbbb2rampgaindelta,msw);
; **************************************************
	move	y:(r0),a

	; IGNORE ASMBLR WARNING BELOW (setting x part of l: with y label)
	move	a1,x:F_arbbb2rampgaindelta

;	move	a1,y:(r6)+
	move	#>F_arbbb2rampgaindelta,r1
;	move	r1,y:(r6)+
;	jsr	Fmemwritex
;	move	(r6)-
;	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2rampgaindelta);
; **************************************************
	move	#>F_arbbb2rampgaindelta,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, &msw);	/* msw first, in x: */
; **************************************************
	move	r0,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       memwritex((unsigned*)&_arbbb2rampdownstart,msw);
; **************************************************
	move	y:(r0),a

	; IGNORE ASMBLR WARNING BELOW (setting x part of l: with y label)
	move	a1,x:F_arbbb2rampdownstart

;	move	a1,y:(r6)+
	move	#>F_arbbb2rampdownstart,r1
;	move	r1,y:(r6)+
;	jsr	Fmemwritex
;	move	(r6)-
;	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2rampdownstart);
; **************************************************
	move	#>F_arbbb2rampdownstart,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2burstmode);
; **************************************************
	move	#>F_arbbb2burstmode,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, &msw);	/* msw first, in x: */
; **************************************************
	move	r0,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       memwritex((unsigned*)&_arbbb2burstdelay,msw);
; **************************************************
	move	y:(r0),a

	; IGNORE ASMBLR WARNING BELOW (setting x part of l: with y label)
	move	a1,x:F_arbbb2burstdelay

;	move	a1,y:(r6)+
	move	#>F_arbbb2burstdelay,r1
;	move	r1,y:(r6)+
;	jsr	Fmemwritex
;	move	(r6)-
;	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2burstdelay);
; **************************************************
	move	#>F_arbbb2burstdelay,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, &msw);	/* msw first, in x: */
; **************************************************
	move	r0,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       memwritex((unsigned*)&_arbbb2burstend,msw);
; **************************************************
	move	y:(r0),a

	; IGNORE ASMBLR WARNING BELOW (setting x part of l: with y label)
	move	a1,x:F_arbbb2burstend

;	move	a1,y:(r6)+
	move	#>F_arbbb2burstend,r1
;	move	r1,y:(r6)+
;	jsr	Fmemwritex
;	move	(r6)-
;	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2burstend);	
; **************************************************
	move	#>F_arbbb2burstend,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, &msw);	/* msw first, in x: */
; **************************************************
	move	r0,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       memwritex((unsigned*)&_arbbb2holdoffend,msw);
; **************************************************
	move	y:(r0),a

	; IGNORE ASMBLR WARNING BELOW (setting x part of l: with y label)
	move	a1,x:F_arbbb2holdoffend

;	move	a1,y:(r6)+
	move	#>F_arbbb2holdoffend,r1
;	move	r1,y:(r6)+
;	jsr	Fmemwritex
;	move	(r6)-
;	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2holdoffend);
; **************************************************
	move	#>F_arbbb2holdoffend,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2ch1gaincorr);
; **************************************************
	move	#>F_arbbb2ch1gaincorr,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2ch1gainuser);
; **************************************************
	move	#>F_arbbb2ch1gainuser,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2ch1rngdac);
; **************************************************
	move	#>F_arbbb2ch1rngdac,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2ch2gaincorr);
; **************************************************
	move	#>F_arbbb2ch2gaincorr,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2ch2gainuser);
; **************************************************
	move	#>F_arbbb2ch2gainuser,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2ch2rngdac);
; **************************************************
	move	#>F_arbbb2ch2rngdac,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2dfdelay);
; **************************************************
	move	#>F_arbbb2dfdelay,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2spanmode);
; **************************************************
	move	#>F_arbbb2spanmode,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       break;
; **************************************************
	jmp	L2
L7
L2
; **************************************************
;   }
;     
;     switch (extcmd){
; **************************************************
	move	#-3,n0
	move	#>8388660,b
	move	y:(r0+n0),a
	move	#0,a2
	move	#0,b2
	cmp	b,a
	jeq	L10
	move	#>8388661,b
	move	#0,a2
	move	#0,b2
	cmp	b,a
	jeq	L11
	jmp	L13
L10
; **************************************************
;   case ARBBB2_BUFRSETUP:
;       /* read in arb srcbuffer parameters */
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2_srcbuffer_mode);
; **************************************************
	move	#>F_arbbb2_srcbuffer_mode,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2_srcbuffer_x_size);
; **************************************************
	move	#>F_arbbb2_srcbuffer_x_size,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2_srcbuffer_y_size);
; **************************************************
	move	#>F_arbbb2_srcbuffer_y_size,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2_srcbuffer_initmode);
; **************************************************
	move	#>F_arbbb2_srcbuffer_initmode,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       __arbbb2_srcbuffer_init();
; **************************************************
	jsr	F__arbbb2_srcbuffer_init
; **************************************************
;       break;
; **************************************************
	jmp	L9
L11
; **************************************************
; 
;   case ARBBB2_BUFRMAXRD:
;       /* returns srcbuffer_x_max and srcbuffer_y_max */
;       /* write out a zero to host port*/
;       temp0 = 0;
; **************************************************
	clr	a
	move	(r0)+
	move	a1,y:(r0)-
; **************************************************
;       memwritex((unsigned*)&dsp_htx, temp0);
; **************************************************
	move	(r0)+
	move	y:(r0)-,a

	move	a1,x:Fdsp_htx

;	move	a1,y:(r6)+
	move	#>Fdsp_htx,r1
;	move	r1,y:(r6)+
;	jsr	Fmemwritex
;	move	(r6)-
;	move	(r6)-
; **************************************************
; 
;       /* write out first word to host port*/
;       memwritex((unsigned*)&dsp_htx, _arbbb2_srcbuffer_x_max);
; **************************************************
	move	y:F_arbbb2_srcbuffer_x_max,a

	move	a1,x:Fdsp_htx

;	move	a1,y:(r6)+
	move	#>Fdsp_htx,r1
;	move	r1,y:(r6)+
;	jsr	Fmemwritex
;	move	(r6)-
;	move	(r6)-
; **************************************************
;       bufr_hpxmit_reset(&bufparm_out);
; **************************************************
	move	#>Fbufparm_out,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_hpxmit_reset
	move	(r6)-
; **************************************************
;       /* write out second word to buffer */
;       bufr_write(&bufparm_out, _arbbb2_srcbuffer_y_max);
; **************************************************
	move	y:F_arbbb2_srcbuffer_y_max,a
	move	a1,y:(r6)+
	move	#>Fbufparm_out,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_write
	move	(r6)-
	move	(r6)-
; **************************************************
;       break;
; **************************************************
	jmp	L9
L13
L9
; **************************************************
;   }
; }
; **************************************************
L1
	move	(r6)-
	move	y:(r6)-,r1
	move	y:(r6)-,b
	move	y:(r6),b0
	move	(r0)-
	move	y:(r0)-,ssh
	move	r0,r6
	move	y:(r0),r0
	rts

Farbbb2gaincorr
	move	ssh,y:(r6)+
	move	r1,y:(r6)+
; **************************************************
; **************************************************
; **************************************************
;  void
;  arbbb2gaincorr()               /*______*/
;  /* set randbb gain factors */
;  {
;  bdparms_gaincorr((unsigned*)&_arbbb2ch1gaincorr,(unsigned*)&_arbbb2ch2gaincorr);
; **************************************************
	move	#>F_arbbb2ch2gaincorr,r1
	move	r1,y:(r6)+
	move	#>F_arbbb2ch1gaincorr,r1
	move	r1,y:(r6)+
	jsr	Fext_bdparms_gaincorr
	move	(r6)-
	move	(r6)-
; **************************************************
;  /*  sets gain correction based on acr setting hierachy */
;  }
; **************************************************
L14
	move	(r6)-
	move	y:(r6),r1
	move	y:-(r6),ssh
	nop
	rts

; 

